/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class AlgebraFenster
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static Lauf lauf;
    JPanel pan = new JPanel(new BorderLayout());
    JMenuBar balken;
    JMenu ablage;
    JMenu bearbeiten;
    JMenuItem neu;
    JMenuItem oeffnen;
    JMenuItem speichern;
    JMenuItem speichernAls;
    JMenuItem export;
    JMenuItem drucker;
    JMenuItem drucken;
    JMenuItem ohnesichern;
    JMenuItem beenden;
    JMenuItem widerrufen;
    JMenuItem loeschen;
    JMenuItem einkopieren;
    JMenuItem auskopieren;
    JMenuItem interpretieren;
    JMenuItem finden;
    JMenuItem txt;
    JMenuItem tex;
    JMenuItem html;
    JTextField suchwort;
    JTextArea algebraEingabe;
    JTextArea hilfe;
    JEditorPane algebraAusgabe;
    JCheckBox sichernBox;
    JCheckBox kompakt;
    JCheckBox zerlegt;
    JCheckBox nett;
    JCheckBox zeitmessung;
    JCheckBox mitHilfe;
    JButton interKnopf;
    JButton loeschKnopf;
    JButton widerKnopf;
    JButton sichernKnopf;
    JButton exportKnopf;
    JButton suchen;
    JButton ok;
    JButton simp;
    JButton eval;
    JButton faktor;
    JButton nullstelle;
    JButton loese;
    JButton differential;
    JButton integral;
    JButton poly;
    JButton gz;
    JButton pfz;
    JButton prim;
    JButton cz;
    JButton zuw;
    JComboBox schriftgross;
    JComboBox sonderzeichen;
    JComboBox stellen;
    JComboBox ausgabeform;
    JScrollPane hilfeText;
    static String datei;
    static String ordner;
    boolean gesichert = false;
    boolean sauber = true;
    int zeichenzahl = 0;
    int aktZeile = 0;
    int htmlGross = 11;
    boolean zeit = false;
    boolean bsp = true;
    boolean wider = true;
    boolean flex = false;
    String letzteEingabe = "";
    static boolean abbruch;
    static String zuweisung;
    static int suchStart;
    String beispiele = "";
    boolean solo = false;

    static {
        datei = "Neu";
        ordner = "";
        abbruch = false;
        zuweisung = "\u27a4";
        suchStart = 0;
    }

    void itemAnlegen(JMenu m, JMenuItem i, int s, boolean u, boolean e) {
        if (s > -1) {
            if (u) {
                i.setAccelerator(KeyStroke.getKeyStroke(s, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
            } else {
                i.setAccelerator(KeyStroke.getKeyStroke(s, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
        }
        i.setEnabled(e);
        i.addActionListener(this);
        m.add(i);
    }

    AlgebraFenster(String t, boolean solo) {
        super(t);
        this.solo = solo;
        this.setDefaultCloseOperation(0);
        int dim = Geopro.dimension;
        if (dim == 1) {
            this.setLocation(3, 3);
            this.balken = new JMenuBar();
            this.ablage = new JMenu("Ablage");
            this.neu = new JMenuItem("Neu");
            this.itemAnlegen(this.ablage, this.neu, 78, false, true);
            this.oeffnen = new JMenuItem("\u00d6ffnen...");
            this.itemAnlegen(this.ablage, this.oeffnen, 79, false, true);
            this.ablage.addSeparator();
            this.speichern = new JMenuItem("Sichern");
            this.itemAnlegen(this.ablage, this.speichern, 83, false, true);
            this.speichernAls = new JMenuItem("Sichern als...");
            this.itemAnlegen(this.ablage, this.speichernAls, 83, true, true);
            this.export = new JMenuItem("Ausgabe-Export...");
            this.itemAnlegen(this.ablage, this.export, -1, false, true);
            this.ablage.addSeparator();
            this.drucker = new JMenuItem("Papierformat...");
            this.itemAnlegen(this.ablage, this.drucker, 80, true, true);
            this.drucken = new JMenuItem("Ausgabe drucken...");
            this.itemAnlegen(this.ablage, this.drucken, 80, false, true);
            this.ablage.addSeparator();
            this.ohnesichern = new JMenuItem("Ohne Sichern beenden...");
            this.itemAnlegen(this.ablage, this.ohnesichern, 66, true, true);
            this.beenden = new JMenuItem("Beenden...");
            this.itemAnlegen(this.ablage, this.beenden, 66, false, true);
            this.bearbeiten = new JMenu("Bearbeiten");
            this.widerrufen = new JMenuItem("Eingabe widerrufen");
            this.itemAnlegen(this.bearbeiten, this.widerrufen, 90, false, true);
            this.loeschen = new JMenuItem("Alles l\u00f6schen");
            this.itemAnlegen(this.bearbeiten, this.loeschen, -1, false, true);
            this.bearbeiten.addSeparator();
            this.einkopieren = new JMenuItem("Eingabe kopieren");
            this.itemAnlegen(this.bearbeiten, this.einkopieren, 67, false, true);
            this.auskopieren = new JMenuItem("Ausgabe kopieren");
            this.itemAnlegen(this.bearbeiten, this.auskopieren, 67, true, true);
            this.bearbeiten.addSeparator();
            this.interpretieren = new JMenuItem("Eingabe interpretieren");
            this.itemAnlegen(this.bearbeiten, this.interpretieren, 73, false, true);
            this.bearbeiten.addSeparator();
            this.finden = new JMenuItem("Befehl suchen");
            this.itemAnlegen(this.bearbeiten, this.finden, 70, false, true);
            this.balken.add(this.ablage);
            this.balken.add(this.bearbeiten);
            this.setJMenuBar(this.balken);
            new Ablage();
        } else {
            this.setLocation(3, 60);
        }
        this.setSize(1220, 800);
        this.addWindowListener(new AlgebraFensterLauscher());
        JSplitPane algebraPane = new JSplitPane();
        algebraPane.setOrientation(0);
        algebraPane.setDividerLocation(340);
        JPanel knopfPanel = new JPanel(null);
        knopfPanel.setPreferredSize(new Dimension(80, 0));
        int l = 0;
        int o = 80;
        int s = 27;
        int b = 75;
        int h = 24;
        this.suchen = new JButton("Suche:");
        this.suchen.setBounds(l, 0, b, h);
        this.suchen.addActionListener(this);
        knopfPanel.add(this.suchen);
        this.suchwort = new JTextField();
        this.suchwort.setBounds(l + 3, 25, b - 6, h);
        this.suchwort.addActionListener(this);
        knopfPanel.add(this.suchwort);
        this.suchwort.setToolTipText("Der Befehl kann mit [RETURN] in der Hilfe gesucht werden.");
        this.suchwort.setFont(new Font("Courier", 0, 11));
        this.ok = new JButton("OK");
        this.ok.setBounds(l, 50, b, h);
        this.ok.addActionListener(this);
        knopfPanel.add(this.ok);
        this.ok.setToolTipText("Der Befehl im obigen Textfeld kann in der Eingabe geschrieben werden.");
        this.simp = new JButton("Simp");
        this.simp.setBounds(l, o + 0 * s, b, h);
        this.simp.addActionListener(this);
        knopfPanel.add(this.simp);
        this.eval = new JButton("Eval");
        this.eval.setBounds(l, o + 1 * s, b, h);
        this.eval.addActionListener(this);
        knopfPanel.add(this.eval);
        this.faktor = new JButton("Faktor");
        this.faktor.setBounds(l, o + 2 * s, b, h);
        this.faktor.addActionListener(this);
        knopfPanel.add(this.faktor);
        this.nullstelle = new JButton("Null");
        this.nullstelle.setBounds(l, o + 3 * s, b, h);
        this.nullstelle.addActionListener(this);
        knopfPanel.add(this.nullstelle);
        this.loese = new JButton("L\u00f6se");
        this.loese.setBounds(l, o + 4 * s, b, h);
        this.loese.addActionListener(this);
        knopfPanel.add(this.loese);
        this.differential = new JButton("Dif");
        this.differential.setBounds(l, o + 5 * s, b, h);
        this.differential.addActionListener(this);
        knopfPanel.add(this.differential);
        this.integral = new JButton("Int");
        this.integral.setBounds(l, o + 6 * s, b, h);
        this.integral.addActionListener(this);
        knopfPanel.add(this.integral);
        this.poly = new JButton("Poly");
        this.poly.setBounds(l, o + 7 * s, b, h);
        this.poly.addActionListener(this);
        knopfPanel.add(this.poly);
        this.gz = new JButton("GZ");
        this.gz.setBounds(l, o + 8 * s, b, h);
        this.gz.addActionListener(this);
        knopfPanel.add(this.gz);
        this.pfz = new JButton("Pfz");
        this.pfz.setBounds(l, o + 9 * s, b, h);
        this.pfz.addActionListener(this);
        knopfPanel.add(this.pfz);
        this.prim = new JButton("Prim");
        this.prim.setBounds(l, o + 10 * s, b, h);
        this.prim.addActionListener(this);
        knopfPanel.add(this.prim);
        this.cz = new JButton("CZ");
        this.cz.setBounds(l, o + 11 * s, b, h);
        this.cz.addActionListener(this);
        knopfPanel.add(this.cz);
        this.zuw = new JButton(zuweisung);
        this.zuw.setBounds(l, o + 12 * s + 5, b, h);
        this.zuw.addActionListener(this);
        knopfPanel.add(this.zuw);
        JPanel algebraPanel = new JPanel(new BorderLayout());
        this.algebraEingabe = new JTextArea(24, 0);
        this.algebraEingabe.addKeyListener(new Algebralauscher());
        this.algebraEingabe.setFont(new Font("Courier", 0, 11));
        DropLauscher dropLauscher = new DropLauscher();
        new DropTarget(this.algebraEingabe, dropLauscher);
        JScrollPane rollEinText = new JScrollPane(this.algebraEingabe);
        this.algebraAusgabe = new JEditorPane();
        this.algebraAusgabe.setForeground(Color.red);
        this.algebraAusgabe.setFont(new Font("Courier", 0, 11));
        JScrollPane rollAusText = new JScrollPane(this.algebraAusgabe);
        this.hilfe = new JTextArea(0, 35);
        this.hilfe.setForeground(Color.gray);
        this.hilfe.setFont(new Font("Courier", 0, 11));
        this.hilfe.setEditable(false);
        this.hilfe.setSelectionColor(Color.yellow);
        this.hilfeText = new JScrollPane(this.hilfe);
        this.hilfe.setText(this.beispiele);
        JPanel algbraButtons = new JPanel();
        algbraButtons.setMaximumSize(new Dimension(0, 30));
        algbraButtons.setLayout(new FlowLayout(1, 5, 5));
        JPanel algbraOption = new JPanel();
        algbraOption.setMaximumSize(new Dimension(0, 30));
        algbraOption.setLayout(new FlowLayout(1, 5, 5));
        this.interKnopf = new JButton("Interpretieren ($)");
        this.interKnopf.setToolTipText("Alle Zeilen werden interpretiert. (auch mit $)");
        this.interKnopf.setFont(new Font("Arial", 0, 11));
        this.interKnopf.addActionListener(this);
        this.interKnopf.setFocusable(false);
        algbraButtons.add(this.interKnopf);
        this.loeschKnopf = new JButton("L\u00f6schen");
        this.loeschKnopf.setToolTipText("Eingabe und Ausgabe werden gel\u00f6scht.");
        this.loeschKnopf.setFont(new Font("Arial", 0, 11));
        this.loeschKnopf.addActionListener(this);
        this.loeschKnopf.setFocusable(false);
        algbraButtons.add(this.loeschKnopf);
        this.widerKnopf = new JButton("Widerrufen");
        this.widerKnopf.setToolTipText("Eingabe und Ausgabe werden widerrufen.");
        this.widerKnopf.setFont(new Font("Arial", 0, 11));
        this.widerKnopf.addActionListener(this);
        this.widerKnopf.setFocusable(false);
        algbraButtons.add(this.widerKnopf);
        this.sonderzeichen = new JComboBox();
        this.sonderzeichen.setFont(new Font("Courier", 0, 11));
        this.sonderzeichen.addItem("Sonderzeichen");
        this.sonderzeichen.addItem(" " + zuweisung + " ");
        this.sonderzeichen.addItem("^");
        this.sonderzeichen.addItem(Character.valueOf(Geopro.grad));
        this.sonderzeichen.addItem("\u2229");
        this.sonderzeichen.addItem("\u222a");
        this.sonderzeichen.addItem("\u2193");
        this.sonderzeichen.addItem("\u2022");
        this.sonderzeichen.addItem("\u00d7");
        this.sonderzeichen.addItem("\u2261");
        this.sonderzeichen.addItem("\u00ac");
        this.sonderzeichen.addItem("\u2227");
        this.sonderzeichen.addItem("\u2228");
        this.sonderzeichen.addItem("\u22bb");
        this.sonderzeichen.addItem("\u2192");
        this.sonderzeichen.addActionListener(this);
        this.sonderzeichen.setFocusable(false);
        algbraButtons.add(this.sonderzeichen);
        this.schriftgross = new JComboBox();
        this.schriftgross.setToolTipText("Schriftgr\u00f6sse im Ein- und Ausgabefenster setzen.");
        this.schriftgross.setFont(new Font("Arial", 0, 11));
        this.schriftgross.addItem("Schriftgr\u00f6sse");
        int i = 0;
        while (i <= 7) {
            this.schriftgross.addItem(9 + i);
            ++i;
        }
        this.schriftgross.setSelectedIndex(0);
        this.schriftgross.addActionListener(this);
        this.schriftgross.setFocusable(false);
        algbraButtons.add(this.schriftgross);
        this.sichernBox = new JCheckBox("... \u00fcbernehmen in Datei", false);
        this.sichernBox.setToolTipText("Inhalt des Eingabefensters wird in die Geopro-Datei \u00fcbernommen.");
        this.sichernBox.setFont(new Font("Arial", 0, 11));
        this.sichernBox.addActionListener(this);
        this.sichernBox.setFocusable(false);
        this.sichernBox.setVisible(Geopro.dimension >= 2);
        algbraButtons.add(this.sichernBox);
        this.sichernKnopf = new JButton("Sichern als...");
        this.sichernKnopf.setToolTipText("Die Eingabe wird in einer eigenen Datei gesichert.");
        this.sichernKnopf.setFont(new Font("Arial", 0, 11));
        this.sichernKnopf.addActionListener(this);
        this.sichernKnopf.setFocusable(false);
        if (Geopro.dimension != 1) {
            algbraButtons.add(this.sichernKnopf);
        }
        this.stellen = new JComboBox();
        this.stellen.setFont(new Font("Arial", 0, 12));
        this.stellen.addItem("0 Stellen");
        this.stellen.addItem("1 Stelle");
        this.stellen.addItem("2 Stellen");
        this.stellen.addItem("3 Stellen");
        this.stellen.addItem("4 Stellen");
        this.stellen.addItem("5 Stellen");
        this.stellen.addItem("10 Stellen");
        this.stellen.addItem("exakt");
        this.stellen.addActionListener(this);
        this.stellen.setSelectedIndex(Geopro.stellen);
        this.stellen.setFocusable(false);
        algbraOption.add(this.stellen);
        this.ausgabeform = new JComboBox();
        this.ausgabeform.setToolTipText("Ausgabeform waehlen.");
        this.ausgabeform.setFont(new Font("Arial", 0, 11));
        this.ausgabeform.setBounds(185, 7, 60, 22);
        this.ausgabeform.addItem("Text-Format");
        this.ausgabeform.addItem("HTML-Format");
        this.ausgabeform.addItem("LaTeX-Format");
        this.ausgabeform.addActionListener(this);
        this.ausgabeform.setFocusable(false);
        algbraOption.add(this.ausgabeform);
        this.exportKnopf = new JButton("Ausgabe-Export...");
        this.exportKnopf.setToolTipText("Ausgabe im eingestellten Format exportieren");
        this.exportKnopf.setFont(new Font("Arial", 0, 11));
        this.exportKnopf.addActionListener(this);
        this.exportKnopf.setFocusable(false);
        this.exportKnopf.setVisible(dim != 1);
        algbraOption.add(this.exportKnopf);
        this.kompakt = new JCheckBox("... kompakt", Geopro.kompakt);
        this.kompakt.setToolTipText("Terme mit Abstand und Malpunkten schreiben.");
        this.kompakt.setFont(new Font("Arial", 0, 11));
        this.kompakt.addActionListener(this);
        this.kompakt.setFocusable(false);
        algbraOption.add(this.kompakt);
        this.zerlegt = new JCheckBox("... zerlegt", Geopro.zerlegt);
        this.zerlegt.setToolTipText("Polynome in zerlegter Form schreiben");
        this.zerlegt.setFont(new Font("Arial", 0, 11));
        this.zerlegt.addActionListener(this);
        this.zerlegt.setFocusable(false);
        algbraOption.add(this.zerlegt);
        this.zeitmessung = new JCheckBox("...Gesamtdauer anzeigen", this.zeit);
        this.zeitmessung.setToolTipText("Dauer einer Operation in ms messen.");
        this.zeitmessung.setFont(new Font("Arial", 0, 11));
        this.zeitmessung.addActionListener(this);
        this.zeitmessung.setFocusable(false);
        algbraOption.add(this.zeitmessung);
        this.mitHilfe = new JCheckBox("... mit Beispielen", this.bsp);
        this.mitHilfe.setToolTipText("Beispiele ein-/ausschalten.");
        this.mitHilfe.setFont(new Font("Arial", 0, 11));
        this.mitHilfe.addActionListener(this);
        this.mitHilfe.setFocusable(false);
        algbraOption.add(this.mitHilfe);
        algebraPane.setTopComponent(rollEinText);
        algebraPane.setBottomComponent(rollAusText);
        algebraPanel.add("West", knopfPanel);
        algebraPanel.add("North", algbraButtons);
        algebraPanel.add("Center", algebraPane);
        algebraPanel.add("South", algbraOption);
        this.pan.add("Center", algebraPanel);
        this.pan.add("East", this.hilfeText);
        this.add(this.pan);
        TitledBorder tit4 = BorderFactory.createTitledBorder("Eingabe");
        tit4.setTitleColor(Color.blue);
        tit4.setTitleFont(new Font("Arial", 2, 12));
        TitledBorder tit5 = BorderFactory.createTitledBorder("Ausgabe");
        tit5.setTitleColor(Color.blue);
        tit5.setTitleFont(new Font("Arial", 2, 12));
        TitledBorder tit6 = BorderFactory.createTitledBorder("Beispiele");
        tit6.setTitleColor(Color.blue);
        tit6.setTitleFont(new Font("Arial", 2, 12));
        rollEinText.setBorder(tit4);
        rollAusText.setBorder(tit5);
        this.hilfeText.setBorder(tit6);
        this.beispiele();
    }

    void beispiele() {
        this.beispiele = String.valueOf(this.beispiele) + "DIVERSES" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "========" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "\"Text\t\t# Textzeile einfuegen" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "\u00a7\t\t# Interpretation anhalten" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + " Leerzeile\t# Leerzeile durch Einruecken" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "2 " + zuweisung + " f\t\t# Zuweisung (mit Tabulator)" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ZAHLENTHEORIE (+ \u2013 * / : % ^ \u2229 \u222a ! \u2193)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "=====================================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GF(p)\t\t# Galois-Feld mit Primzahl p" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(123^45)\t# Ganze Zahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(1+2//3+4)\t# Bruchzahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ((4/3)^21)\t# Grosse Bruchzahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(24\u222932)\t# ggT" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(24\u222a32)\t# kgV" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(100!)\t# Fakultaet" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(100\u219350)\t# Binomialkoeffizient" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Pfz(1000!)\t# Primfaktorzerlegung" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Prim(100!+1)\t# Primtest" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GZ(2/3)\u20264\t# Rundung einer Zahl mit Stellenzahl" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ALGEBRA (+ \u2013 * / : % ^)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "=======================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "GF(p)\t\t\t# Galois-Feld mit Ordnung p" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Simp(\u2026)\t\t\t# Univariate Polynome bzw. Bruchterme von Polynomen" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Simp(x^3+1//x+1)\t# Bruchterm vereinfachen" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Zae(x^3+1//x-1)\t\t# Zaehler eines Bruchterms" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Nen(x^3+1//x-1)\t\t# Nenner eines Bruchterms" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Div(x^3+1,x-1)\t\t# Division ohne Rest der Division" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Mod(x^3+1,x-1)\t\t# Rest der Division" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Ggt(x^3+1,x^2-1)\t# GgT von Polynomen" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Kgv(x^3+1,x^2-1)\t# KgV von Polynomen" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Dif(x+1//x+2)\t\t# Ableitung eines Bruchterms" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Dif(x+1//x+2,3)\t\t# Ableitung eines Bruchterms an einer Stelle" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Int(x^2)\t\t# Stammfunktion eines Polynoms" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Int(x^2,1)\t\t# Integralfunktion eines Polynoms an einer Stelle" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Eval(x+1//x+2,3)\t# Auswertung eines Bruchterms an einer Stelle" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Eval(x+1//x+2,4)\u20265\t# Auswertung eines Bruchterms an einer Stelle als Dezimalzahl mit Stellenzahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Faktor(x^5-1)\t\t# Faktorisierung eines Polynoms" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Null(x^2-x-2)\t\t# Nullstellen eines Polynoms " + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "L\u00f6se(x^2-x=2)\t\t# L\u00f6sung einer polynomialen Gleichung" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "L\u00f6se(2x+y=4,x-3y=5)\t# L\u00f6sung eines linearen Gleichungssystems" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Var(z)\t\t\t# Variable f, g, ..., z statt x definieren" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Simp((z+1)^3) " + zuweisung + " F (G, ...,J)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "==================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(\u2026)\t\t\t# Multivariate Polynome" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly((a+b+c)^3)\t\t# Polynom vereinfachen" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Div(x^2,x+1))\t# Division ohne Rest der Division" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Mod(x^2,x+1))\t# Rest der Division" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Dif(ax^2))\t\t# Polynom (nach x) ableiten" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Dif(ax^2,1))\t# Polynom (nach x) ableiten an Stelle 1" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Dif(ax^2,a))\t# Polynom (nach a) ableiten" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Int(ax^2))\t\t# Polynom (nach x) integrieren" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Int(ax^2,1))\t# Polynom (nach x) integrieren an Stelle 1" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Int(ax^2,1,2))\t# Polynom (nach x) integrieren von 1 bis 2" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "Poly(Int(ax^2,a))\t# Polynom (nach a) integrieren" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ARITHMETIK (+ \u2013 * / : % ^)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "=========================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "abs(-1)\t\t# Absolutbetrag" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "rnd(1.5)\t# Ganzzahlrundung" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "sqr(2)\t\t# Quadratwurzel" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "qua(3)\t\t# Quadratzahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "kub(4)\t\t# Kubikzahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "exp(1)\t\t# Exponentialfunktion" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ln(e)\t\t# Natuerlicher Logarithmus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "lg(100)\t\t# Zehnerlogarithmus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "sin(30" + Geopro.grad + ")\t# Sinus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "cos(\u03c0)\t\t# Cosinus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "tan(45" + Geopro.grad + ")\t# Tangens" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ang(\u03c0)\t\t# Umwandlung in Gradmass (auch ')" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "arc(90)\t\t# Umwandlung in Bogenmass (auch " + Geopro.grad + ")" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "asn(-1)\t\t# Arcusinus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "acs(-1)\t\t# Arcuscosinus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "atn(1)\t\t# Arcustangens" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "snh(0)\t\t# Sinushyperbolicus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "csh(0)\t\t# Cosinushyperbolicus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "tnh(0)\t\t# Tangenshyperbolicus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ash(1)\t\t# Areasinushyperbolicus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ach(1)\t\t# Areacosinushyperbolicus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "ath(0.5)\t# Areatangenshyperbolicus" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "\u03a6(0)\t\t# Stand. Normalverteilung" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "\u03a8(0.95)\t\t# Umkehrung von \u03a6" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "7/13\u20264\t\t# Rundung einer Zahl mit Stellenzahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "7/13 " + zuweisung + " f (g, ...,z)" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "KOMPLEXE ZAHLEN (+ \u2013 * / // ^)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "==================================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(cis(\u03c0/2))\t# cis-Form mit Winkel" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(3+4i)\t# Komplexe Zahl mit imaginaerer Einheit i" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(kon(3+4i))\t# Konjugiert-komplexe Zahl" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(abs(3+4i))\t# Betrag" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(arg(3+4i))\t# Polarwinkel im Bogenmass" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(sqr(3+4i))\t# Quadratwurzel" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(exp(3+4i))\t# Exponential-Funktion" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(log(3+4i))\t# Logarithmus-Funktion" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(sin(3+4i))\t# Sinus-Funktion" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(cos(3+4i))\t# Cosinus-Funktion" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(tan(3+4i))\t# Tangens-Funktion" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "CZ(2/3+4/7i)\u20264\t# Rundung einer Zahl mit Stellenzahl <16" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "LOGIK (\u2261 < > \u00ac \u2227 \u2228 \u22bb \u2192)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "=======================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "a\u2261b" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "if(\u03c0^e>e^\u03c0,1,2)" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "NUMERIK" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "=======" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "null(x^3-2,1)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "sum(x,1,100)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "lim((1+x)^(1/x),0)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "dif(tan(x),0)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "dif2(exp(x),1)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "int(sin(x),0,\u03c0)" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "VEKTOREN (+ - * / \u2022 \u00d7)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "======================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2,3]+[4,5,6]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2,3]-[4,5,6]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "4*[1,2,3]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2,3]/4" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2,3]\u2022[4,5,6]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2,3]\u00d7[4,5,6]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2,3] " + zuweisung + " U (V, ...,Z)" + Geopro.cr + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "MATRIZEN (+ - * / \u2022)" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "====================" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2;3,4]+[5,6;7,8]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2;3,4]-[5,6;7,8]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2;3,4]\u2022[5,6;7,8]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "5*[1,2;3,4]" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "[1,2;3,4]/5" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "det([1,2;3,4])" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "inv([1,2;3,4])" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "inv([1,2,3;4,5,6;7,8,10])" + Geopro.cr;
        this.beispiele = String.valueOf(this.beispiele) + "trp([1,2;3,4])";
        this.hilfe.setText(this.beispiele);
    }

    static String fehler(int nr) {
        String s = "";
        switch (nr) {
            case 1: {
                s = "Syntaxfehler";
                break;
            }
            case 2: {
                s = "Klammern stimmen nicht.";
                break;
            }
            case 3: {
                s = "Funktion bzw. Operation hat zu viele Argumente.";
                break;
            }
            case 9: {
                s = "Funktion oder Operation ist nicht bekannt.";
                break;
            }
            case 10: {
                s = "Funktionswert ist zu gross.";
                break;
            }
            case 11: {
                s = "Funktionswert ist nicht definiert f\u00fcr dieses Argument.";
                break;
            }
            case 12: {
                s = "Operation ist nicht definiert.";
                break;
            }
            case 14: {
                s = "Argument ist zu gross.";
                break;
            }
            case 15: {
                s = "Argument darf nicht negativ sein.";
                break;
            }
            case 16: {
                s = "Funktion ist nicht definiert.";
                break;
            }
            case 22: {
                s = "Funktion ist fuer dieses Argument nicht bekannt.";
                break;
            }
            case 38: {
                s = "Eine Eingabe ist fehlerhaft.";
                break;
            }
            case 19: 
            case 23: {
                s = "Operation ist nicht bekannt.";
                break;
            }
            case 18: {
                s = "Funktion bzw. Operation mit diesen Argumenten ist nicht bekannt.";
                break;
            }
            case 5: {
                s = "Index ist nicht definiert.";
                break;
            }
            case 21: {
                s = "Vorzeichen ist nicht bekannt.";
                break;
            }
            case 17: {
                s = "Variable ist nicht definiert.";
                break;
            }
            case 32: {
                s = "Zuweisung ist nicht erlaubt.";
                break;
            }
            case 7: {
                s = "Argument ist keine positive ganze Zahl.";
                break;
            }
            case 4: {
                s = "Ein Argument ist nicht rational.";
                break;
            }
            case 13: {
                s = "Division durch 0 ist nicht definiert.";
                break;
            }
            case 27: {
                s = "Stellenzahl muss ganzzahlig sein und zwischen 0 und 10 liegen.";
                break;
            }
            case 31: {
                s = "Stellenzahl muss ganzzahlig sein und zwischen 0 und 15 liegen.";
                break;
            }
            case 8: {
                s = "GZ ist nicht definiert fuer das Argument.";
                break;
            }
            case 34: {
                s = "Exponent ist nicht ganzzahlig.";
                break;
            }
            case 35: {
                s = "Exponent ist nicht positiv.";
                break;
            }
            case 36: {
                s = "Exponent muss ganzzahlig sein.";
                break;
            }
            case 28: {
                s = "Modulus muss ganzzahlig sein.";
                break;
            }
            case 6: {
                s = "Argument ist kein nichtkonstantes Polynom.";
                break;
            }
            case 24: {
                s = "Kein Polynom.";
                break;
            }
            case 26: {
                s = "Eval ben\u00f6tigt Zahl als Eingabe.";
                break;
            }
            case 29: {
                s = "Nenner ist irreduzibel.";
                break;
            }
            case 30: {
                s = "Keine Partialbruchzerlegung moeglich.";
                break;
            }
            case 37: {
                s = "Polynomdivision ist nicht moeglich.";
                break;
            }
            case 33: {
                s = "Loesung existiert nicht.";
                break;
            }
            case 39: {
                s = "Kein passendes Gleichungssystem.";
                break;
            }
            case 40: {
                s = "Keine Stammfunktion gefunden.";
                break;
            }
            case 41: {
                s = "Kann nicht integriert werden an der Stelle.";
                break;
            }
            case 42: {
                s = "Kann nicht integriert werden mit den Grenzen.";
                break;
            }
            case 43: {
                s = "Kann nicht ausgewertet werden an der Stelle.";
                break;
            }
            default: {
                s = "Fehler";
            }
        }
        return s;
    }

    void cursor(int nr) {
        switch (nr) {
            case 0: {
                this.algebraEingabe.setCursor(Cursor.getPredefinedCursor(2));
                break;
            }
            case 1: {
                this.algebraEingabe.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    String unterstreichen() {
        String s = "";
        int i = 0;
        while (i < this.zeichenzahl) {
            s = String.valueOf(s) + "=";
            ++i;
        }
        return s;
    }

    void setzeZeile(String txt) {
        String s = this.algebraAusgabe.getText();
        switch (Geopro.form) {
            case 0: {
                this.algebraAusgabe.setText(String.valueOf(s) + txt + Geopro.cr);
                break;
            }
            case 2: {
                this.algebraAusgabe.setText(String.valueOf(s) + "$" + this.texString(txt) + "$\\\\" + Geopro.cr);
            }
        }
    }

    void htmlText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String hText = text;
                hText = text.replace(Geopro.cr, "<br>");
                HTMLEditorKit kit = new HTMLEditorKit();
                AlgebraFenster.this.algebraAusgabe.setEditorKit(kit);
                StyleSheet css = kit.getStyleSheet();
                css.addRule("body {color:red; font:" + AlgebraFenster.this.htmlGross + "pt courier; margin:0px; white-space: nowrap;}");
                Document doc = kit.createDefaultDocument();
                AlgebraFenster.this.algebraAusgabe.setDocument(doc);
                String htmlTxt = "<html>\n<body>\n" + hText + "\n" + "</body>\n" + "</html>\n";
                AlgebraFenster.this.algebraAusgabe.setText(htmlTxt);
            }
        });
    }

    void voreinstellungen() {
        this.algebraAusgabe.setText("");
        Geopro.form = this.ausgabeform.getSelectedIndex();
        if (Geopro.form == 1) {
            this.algebraAusgabe.setContentType("text/html");
        } else {
            this.algebraAusgabe.setContentType("text/plain");
        }
        Geopro.modul = 0;
    }

    String texhoch(String s) {
        String ts = "";
        ts = s;
        return ts;
    }

    void allesInterpretieren(String eingabe) {
        boolean alles = true;
        this.sauber = false;
        this.voreinstellungen();
        this.cursor(1);
        String text = "";
        int l = eingabe.length();
        if (l > 0) {
            if (alles && eingabe.charAt(l - 1) != '\n') {
                eingabe = String.valueOf(eingabe) + Geopro.cr;
                this.algebraEingabe.append(Geopro.cr);
            }
            StringTokenizer st = new StringTokenizer(eingabe, String.valueOf(Geopro.cr) + "\\#\t");
            String ein = "";
            String aus = "";
            boolean stopp = false;
            long startTotal = 0L;
            if (this.zeitmessung.isSelected()) {
                startTotal = System.currentTimeMillis();
            }
            try {
                while (!abbruch && st.hasMoreTokens() && !stopp) {
                    Thread.sleep(1L);
                    ein = st.nextToken();
                    if (ein.charAt(0) == '\"') {
                        this.zeichenzahl = ein.substring(1).length();
                        if (Geopro.form == 1) {
                            text = String.valueOf(text) + "<b>" + ein.substring(1) + "</b>" + Geopro.cr;
                            continue;
                        }
                        this.setzeZeile(ein.substring(1));
                        continue;
                    }
                    if (ein.charAt(0) == ' ') {
                        if (!alles) continue;
                        if (Geopro.form == 1) {
                            text = String.valueOf(text) + Geopro.cr;
                            continue;
                        }
                        this.setzeZeile("");
                        continue;
                    }
                    if (ein.charAt(0) == '=') {
                        if (!alles) continue;
                        switch (Geopro.form) {
                            case 0: {
                                this.setzeZeile(this.unterstreichen());
                                break;
                            }
                            case 1: {
                                text = String.valueOf(text) + "=" + Geopro.cr;
                                break;
                            }
                            case 2: {
                                this.setzeZeile("=");
                            }
                        }
                        continue;
                    }
                    if (ein.charAt(0) == '\u00a7') {
                        stopp = true;
                        continue;
                    }
                    if (ein.length() > 0) {
                        aus = Skalar.casWert(ein, Geopro.exakt, true, true);
                    }
                    this.zeichenzahl = aus.length();
                    switch (Geopro.form) {
                        case 0: {
                            this.setzeZeile(aus);
                            break;
                        }
                        case 1: {
                            text = String.valueOf(text) + aus + Geopro.cr;
                            break;
                        }
                        case 2: {
                            aus = this.texhoch(aus);
                            this.setzeZeile(aus);
                        }
                    }
                }
                long stopTotal = 0L;
                long dauerTotal = 0L;
                if (startTotal > 0L) {
                    stopTotal = System.currentTimeMillis();
                    dauerTotal = stopTotal - startTotal;
                    if (dauerTotal < 1000L) {
                        if (Geopro.form == 1) {
                            text = String.valueOf(text) + "Dauer: " + dauerTotal + "ms";
                        } else {
                            this.setzeZeile("Dauer: " + dauerTotal + "ms");
                        }
                    } else if (Geopro.form == 1) {
                        text = String.valueOf(text) + "Dauer: " + dauerTotal / 1000L + "s";
                    } else {
                        this.setzeZeile("Dauer: " + dauerTotal / 1000L + "s");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Geopro.form == 1) {
            this.htmlText(text);
        }
        if (this.sichernBox.isSelected()) {
            Geopro.unsauber();
        }
        this.cursor(0);
        this.algebraEingabe.setSelectionStart(1000);
        this.algebraAusgabe.setSelectionStart(100000);
    }

    void loeschen() {
        this.suchwort.setText("");
        this.letzteEingabe = this.algebraEingabe.getText();
        this.algebraEingabe.setText("");
        this.algebraAusgabe.setText("");
    }

    void widerrufen() {
        String letzte = this.algebraEingabe.getText();
        this.algebraEingabe.setText(this.letzteEingabe);
        this.letzteEingabe = letzte;
        this.laufen();
    }

    boolean ziffer(char c) {
        return c >= '0' && c <= '9';
    }

    String texString(String s) {
        String ss = s;
        ss = ss.replaceAll("Poly", "\\\\Poly");
        ss = ss.replaceAll("Simp", "\\\\Simp");
        ss = ss.replaceAll("Faktor", "\\\\Faktor");
        ss = ss.replaceAll("Null", "\\\\Null");
        ss = ss.replaceAll("Dif", "\\\\Dif");
        ss = ss.replaceAll("Int", "\\\\Int");
        ss = ss.replaceAll("Eval", "\\\\Eval");
        ss = ss.replaceAll("Ggt", "\\\\Ggt");
        ss = ss.replaceAll("Zae", "\\\\Zae");
        ss = ss.replaceAll("Nen", "\\\\Nen");
        ss = ss.replaceAll("GZ", "\\\\GZ");
        ss = ss.replaceAll("CZ", "\\\\CZ");
        ss = ss.replaceAll("Prim", "\\\\Prim");
        ss = ss.replaceAll("Pfz", "\\\\Pfz");
        ss = ss.replaceAll("abs", "\\\\abs");
        ss = ss.replaceAll("rnd", "\\\\rnd");
        ss = ss.replaceAll("sqr", "\\\\sqr");
        ss = ss.replaceAll("qua", "\\\\qua");
        ss = ss.replaceAll("kub", "\\\\kub");
        ss = ss.replaceAll("exp", "\\\\exp");
        ss = ss.replaceAll("ln", "\\\\ln");
        ss = ss.replaceAll("lg", "\\\\lg");
        ss = ss.replaceAll("sin", "\\\\sin");
        ss = ss.replaceAll("cos", "\\\\cos");
        ss = ss.replaceAll("tan", "\\\\tan");
        ss = ss.replaceAll("snh", "\\\\snh");
        ss = ss.replaceAll("csh", "\\\\csh");
        ss = ss.replaceAll("tnh", "\\\\tnh");
        ss = ss.replaceAll("asn", "\\\\asn");
        ss = ss.replaceAll("acs", "\\\\acs");
        ss = ss.replaceAll("atn", "\\\\atn");
        ss = ss.replaceAll("ash", "\\\\ash");
        ss = ss.replaceAll("ach", "\\\\ach");
        ss = ss.replaceAll("ath", "\\\\ath");
        ss = ss.replaceAll("ang", "\\\\ang");
        ss = ss.replaceAll("arc", "\\\\arc");
        ss = ss.replaceAll("arg", "\\\\arg");
        ss = ss.replaceAll("cis", "\\\\cis");
        ss = ss.replaceAll("num", "\\\\num");
        ss = ss.replaceAll("GF", "\\\\GF");
        ss = ss.replaceAll("mod", "\\\\mod");
        ss = ss.replaceAll("div", "\\\\div");
        ss = ss.replaceAll("ggT", "\\\\ggT");
        ss = ss.replaceAll("kgV", "\\\\kgV");
        ss = ss.replaceAll("dif", "\\\\dif");
        ss = ss.replaceAll("int", "\\\\int");
        ss = ss.replaceAll("\u2013", "-");
        ss = ss.replaceAll("\u00d7", "\\\\times");
        ss = ss.replaceAll("\u2022", "\\\\bullet");
        ss = ss.replaceAll(zuweisung, "\\\\zu");
        ss = ss.replaceAll("\u00b7", "\\\\cdot");
        ss = ss.replaceAll(String.valueOf(Geopro.grad), "^{\\\\circ}");
        ss = ss.replaceAll("\u03c0", "\\\\pi");
        ss = ss.replaceAll(Geopro.falsch, "f");
        ss = ss.replaceAll(" \u2248", "\\\\approx");
        return ss;
    }

    void latex() {
        String text = "";
        text = String.valueOf(text) + Tex.casKopf("{\\large \\bf Algebra-Fenster}\\\\[0.25cm]");
        text = String.valueOf(text) + Tex.casRumpf(this.algebraAusgabe.getText());
        Ablage.algebraExportAls(2, text);
    }

    void laufen() {
        this.algebraAusgabe.setText("");
        if (lauf == null) {
            abbruch = false;
            lauf = new Lauf();
            lauf.start();
            this.aktZeile = 0;
        }
    }

    void stoppen() {
        abbruch = true;
        lauf = null;
    }

    void exportieren() {
        String text = Geopro.algebraFenster.algebraAusgabe.getText();
        if (text.length() > 0) {
            if (Geopro.form == 2) {
                String latex = Tex.casKopf("{\\large \\bf Algebra-Fenster}\\\\[0.25cm]");
                text = latex = String.valueOf(latex) + Tex.casRumpf(text);
            }
            Ablage.algebraExportAls(Geopro.form, text);
        } else {
            Geopro.beep();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj == this.ausgabeform) {
            this.laufen();
        }
    }

    void suchen(String txt) {
        String text = this.hilfe.getText();
        int l = text.length();
        int t = txt.length();
        if (l > 0 && t > 0) {
            if ((suchStart = text.indexOf(txt, suchStart)) >= 0) {
                this.hilfe.select(suchStart, suchStart + t);
                this.hilfe.requestFocus();
                suchStart += t;
            } else {
                Geopro.beep();
                this.hilfe.setCaretPosition(0);
                suchStart = 0;
            }
        } else {
            this.suchwort.requestFocus();
            Geopro.beep();
        }
    }

    void suchen() {
        String txt = this.suchwort.getText();
        this.suchen(txt);
        this.suchwort.requestFocus();
    }

    void einsetzen(String t, boolean mit) {
        this.suchwort.setText(t);
        if (t.length() > 0) {
            String txt = t;
            if (mit) {
                txt = String.valueOf(txt) + "()";
            }
            int s = this.algebraEingabe.getCaretPosition();
            String ein = this.algebraEingabe.getText();
            String ein1 = ein.substring(0, s);
            String ein2 = ein.substring(s);
            this.algebraEingabe.setText(String.valueOf(ein1) + txt + ein2);
            int l = txt.length();
            if (mit) {
                this.algebraEingabe.setCaretPosition(s + l - 1);
            } else {
                this.algebraEingabe.setCaretPosition(s + l);
            }
            this.algebraEingabe.requestFocus();
        }
    }

    void kopieren(boolean ein) {
        String txt = "";
        if (ein) {
            this.algebraEingabe.requestFocus();
            this.algebraEingabe.selectAll();
            txt = this.algebraEingabe.getText();
        } else {
            this.algebraAusgabe.requestFocus();
            this.algebraAusgabe.selectAll();
            txt = this.algebraAusgabe.getText();
        }
        if (txt.length() > 0) {
            StringSelection s = new StringSelection(txt);
            this.getToolkit().getSystemClipboard().setContents(s, s);
        } else {
            Geopro.beep();
        }
    }

    void neu() {
        if (this.algebraSchliessen()) {
            datei = "Neu";
            Geopro.algebraFenster.setTitle(datei);
            this.algebraEingabe.setText("");
            this.algebraAusgabe.setText("");
            this.sauber = true;
        }
    }

    void speichern() {
        String text = this.algebraEingabe.getText();
        if (this.gesichert) {
            Ablage.casSichern(text);
        } else {
            Ablage.casSichernAls(text);
        }
    }

    void speichernAls() {
        String text = this.algebraEingabe.getText();
        Ablage.casSichernAls(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (Geopro.dimension == 1) {
            if (obj == this.neu) {
                this.neu();
            } else if (obj == this.oeffnen) {
                if (this.algebraSchliessen()) {
                    Ablage.casOeffnen();
                }
            } else if (obj == this.speichern) {
                this.speichern();
            } else if (obj == this.speichernAls) {
                this.speichernAls();
            } else if (obj == this.export) {
                this.exportieren();
            } else if (obj == this.drucker) {
                Ablage.drucker();
            } else if (obj == this.drucken) {
                Ablage.casDrucken();
            } else if (obj == this.ohnesichern) {
                Geopro.algebraFenster.setVisible(false);
                Geopro.algebraFenster.dispose();
                System.exit(128);
            } else if (obj == this.beenden) {
                if (Geopro.algebraFenster.algebraBeenden()) {
                    Geopro.algebraFenster.setVisible(false);
                    Geopro.algebraFenster.dispose();
                    System.exit(128);
                }
            } else if (obj == this.widerrufen) {
                this.widerrufen();
            } else if (obj == this.einkopieren) {
                this.kopieren(true);
            } else if (obj == this.auskopieren) {
                this.kopieren(false);
            } else if (obj == this.loeschen) {
                this.loeschen();
            } else if (obj == this.interpretieren) {
                this.laufen();
            } else if (obj == this.finden) {
                this.suchen();
            }
        }
        if (obj == this.suchwort || obj == this.suchen) {
            this.suchen();
        } else if (obj == this.ok) {
            this.einsetzen(this.suchwort.getText(), false);
        } else if (obj == this.simp) {
            this.einsetzen("Simp", true);
        } else if (obj == this.faktor) {
            this.einsetzen("Faktor", true);
        } else if (obj == this.eval) {
            this.einsetzen("Eval", true);
        } else if (obj == this.nullstelle) {
            this.einsetzen("Null", true);
        } else if (obj == this.loese) {
            this.einsetzen("L\u00f6se", true);
        } else if (obj == this.differential) {
            this.einsetzen("Dif", true);
        } else if (obj == this.integral) {
            this.einsetzen("Int", true);
        } else if (obj == this.poly) {
            this.einsetzen("Poly", true);
        } else if (obj == this.gz) {
            this.einsetzen("GZ", true);
        } else if (obj == this.pfz) {
            this.einsetzen("Pfz", true);
        } else if (obj == this.prim) {
            this.einsetzen("Prim", true);
        } else if (obj == this.cz) {
            this.einsetzen("CZ", true);
        } else if (obj == this.zuw) {
            this.einsetzen(" " + zuweisung + " ", false);
        } else if (obj == this.interKnopf) {
            this.laufen();
        } else if (obj == this.loeschKnopf) {
            this.loeschen();
        } else if (obj == this.widerKnopf) {
            this.widerrufen();
        } else if (obj == this.sonderzeichen) {
            int index = this.sonderzeichen.getSelectedIndex();
            if (index > 0) {
                String s = this.sonderzeichen.getItemAt(index).toString();
                int l = s.length();
                this.einsetzen(s, l);
            }
            this.sonderzeichen.setSelectedIndex(0);
        } else if (obj == this.schriftgross) {
            int s = this.schriftgross.getSelectedIndex();
            if (s > 0) {
                this.htmlGross = this.schriftgross.getSelectedIndex() + 8;
                this.algebraEingabe.setFont(new Font("Courier", 0, this.htmlGross));
                this.algebraAusgabe.setFont(new Font("Courier", 0, this.htmlGross));
                this.hilfe.setFont(new Font("Courier", 0, 11));
                this.schriftgross.setSelectedIndex(0);
                this.laufen();
            }
        } else if (obj == this.sichernBox) {
            Geopro.unsauber();
        } else if (obj == this.sichernKnopf) {
            this.speichernAls();
        } else if (obj == this.stellen) {
            int aktStellen = Geopro.stellen;
            Geopro.exakt = false;
            int wahl = this.stellen.getSelectedIndex();
            switch (wahl) {
                case 6: {
                    Geopro.stellen = 10;
                    break;
                }
                case 7: {
                    Geopro.exakt = true;
                    break;
                }
                default: {
                    Geopro.stellen = wahl;
                }
            }
            if (Infoleiste.zahlWahl != null) {
                Infoleiste.zahlWahl.setSelectedIndex(wahl);
            }
            if (Geopro.rechnerFenster != null) {
                Geopro.rechnerFenster.stellen.setSelectedIndex(wahl);
            }
            if (Geopro.stellen != aktStellen) {
                Geopro.unsauber();
            }
        } else if (obj == this.ausgabeform) {
            this.laufen();
        } else if (obj == this.exportKnopf) {
            this.exportieren();
        } else if (obj == this.kompakt) {
            Geopro.kompakt = this.kompakt.isSelected();
            this.laufen();
        } else if (obj == this.zerlegt) {
            Geopro.zerlegt = this.zerlegt.isSelected();
            this.laufen();
        } else if (obj == this.mitHilfe) {
            this.bsp = this.mitHilfe.isSelected();
            if (this.bsp) {
                this.hilfeText.setVisible(true);
            } else {
                this.hilfeText.setVisible(false);
            }
            this.pan.updateUI();
        }
    }

    void einsetzen(String txt, int add) {
        String ein = this.algebraEingabe.getText();
        int s1 = this.algebraEingabe.getSelectionStart();
        int s2 = this.algebraEingabe.getSelectionEnd();
        String ein1 = ein.substring(0, s1);
        String ein2 = ein.substring(s2);
        this.algebraEingabe.setText(String.valueOf(ein1) + txt + ein2);
        this.algebraEingabe.setCaretPosition(s1 + add);
        this.algebraEingabe.requestFocus();
    }

    void uebernehmen() {
        Geopro.mitAlgebra = true;
        Geopro.konstruktion[Konstruktion.nummer].altesProtokoll = Geopro.konstruktion[Konstruktion.nummer].protokoll;
        Geopro.konstruktion[Konstruktion.nummer].schreiben();
        Geopro.konstruktion[Konstruktion.nummer].interpretieren();
        Geopro.neuZeichnen();
        Geopro.unsauber();
    }

    boolean algebraBeenden() {
        boolean beenden = true;
        if (!this.gesichert || !this.sauber) {
            ImageIcon bild = Umgebungsleiste.knopf(14);
            Object[] options = new Object[]{"Ja, sichern", "Nein, beenden", "Abbrechen"};
            String s = "Algebra-Fenster beenden";
            int pan = JOptionPane.showOptionDialog(null, "Willst du vor dem Beenden sichern? ", s, -1, 2, bild, options, options[0]);
            switch (pan) {
                case 0: {
                    String text = this.algebraEingabe.getText();
                    if (this.gesichert) {
                        beenden = Ablage.casSichern(text);
                        break;
                    }
                    beenden = Ablage.casSichernAls(text);
                    break;
                }
                case 1: {
                    beenden = true;
                    break;
                }
                case -1: 
                case 2: {
                    beenden = false;
                }
            }
        }
        return beenden;
    }

    boolean algebraSchliessen() {
        boolean schliessen = false;
        if (this.algebraEingabe.getText().length() > 0) {
            if (Geopro.dimension == 1) {
                if (!this.gesichert || !this.sauber) {
                    ImageIcon bild = Umgebungsleiste.knopf(14);
                    Object[] options = new Object[]{"Ja, sichern", "Nein, nicht sichern", "Abbrechen"};
                    int pan = JOptionPane.showOptionDialog(null, "Willst du die Eingabe vorher noch sichern?", "Eingabe sichern", -1, 2, bild, options, options[0]);
                    switch (pan) {
                        case 0: {
                            String text = this.algebraEingabe.getText();
                            if (this.gesichert) {
                                schliessen = Ablage.casSichern(text);
                                break;
                            }
                            schliessen = Ablage.casSichernAls(text);
                            break;
                        }
                        case 1: {
                            schliessen = true;
                            break;
                        }
                        case -1: 
                        case 2: {
                            schliessen = false;
                        }
                    }
                }
                return schliessen;
            }
            if (this.sichernBox.isSelected()) {
                this.uebernehmen();
                schliessen = true;
            } else {
                ImageIcon bild = Geopro.dimension == 2 ? Umgebungsleiste.knopf(12) : Umgebungsleiste.knopf(13);
                Object[] options = new Object[]{"Ja doch, \u00fcbernehmen", "Nein, nicht \u00fcbernehmen", "Abbrechen"};
                int pan = JOptionPane.showOptionDialog(null, "Willst du die Eingabe wirklich nicht\nin die aktuelle GeoPro-Datei \u00fcbernehmen ?", "Algebra-Fenster schliessen", -1, 2, bild, options, options[0]);
                switch (pan) {
                    case 0: {
                        this.sichernBox.setSelected(true);
                        this.uebernehmen();
                        schliessen = true;
                        break;
                    }
                    case 1: {
                        Geopro.algebraFenster.setVisible(false);
                        Geopro.mitAlgebra = false;
                        schliessen = true;
                        break;
                    }
                    case -1: 
                    case 2: {
                        schliessen = false;
                    }
                }
            }
            return schliessen;
        }
        return true;
    }

    class AlgebraFensterLauscher
    extends WindowAdapter {
        AlgebraFensterLauscher() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            AlgebraFenster.this.algebraEingabe.requestFocus();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getWindow() == Geopro.algebraFenster) {
                if (Geopro.dimension == 1) {
                    if (Geopro.algebraFenster.algebraBeenden()) {
                        Geopro.algebraFenster.setVisible(false);
                        Geopro.algebraFenster.dispose();
                        System.exit(128);
                    }
                } else if (Geopro.algebraFenster.algebraSchliessen()) {
                    Geopro.algebraFenster.setVisible(false);
                    Geopro.algebraFenster.dispose();
                }
            }
        }
    }

    class Algebralauscher
    implements KeyListener {
        Algebralauscher() {
        }

        void tastenDruck2(KeyEvent k) {
            if (k.getKeyCode() == 9) {
                k.consume();
                AlgebraFenster.this.einsetzen(" " + zuweisung + " ", 3);
            } else if (k.getKeyCode() == 17) {
                AlgebraFenster.this.einsetzen("^", 1);
            } else if (k.getKeyCode() == 27) {
                AlgebraFenster.this.setzeZeile("Vorgang abgebrochen ..");
                AlgebraFenster.this.stoppen();
            }
        }

        void tastenDruck1(KeyEvent k) {
            char c = k.getKeyChar();
            if (c == '*') {
                k.setKeyChar('\u00b7');
            } else if (c == '^') {
                if (AlgebraFenster.this.flex) {
                    k.consume();
                    AlgebraFenster.this.flex = false;
                } else {
                    AlgebraFenster.this.flex = true;
                }
            } else if (c == '$') {
                k.consume();
                AlgebraFenster.this.laufen();
            }
        }

        @Override
        public void keyTyped(KeyEvent k) {
            this.tastenDruck1(k);
        }

        @Override
        public void keyPressed(KeyEvent k) {
            this.tastenDruck2(k);
        }

        @Override
        public void keyReleased(KeyEvent k) {
        }
    }

    class DropLauscher
    implements DropTargetListener {
        DropLauscher() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent d) {
        }

        @Override
        public void dragExit(DropTargetEvent d) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent d) {
        }

        @Override
        public void dragOver(DropTargetDragEvent d) {
            try {
                Transferable trans = d.getTransferable();
                DataFlavor[] flavors = trans.getTransferDataFlavors();
                int i = 0;
                while (i < flavors.length) {
                    if (flavors[i].isFlavorJavaFileListType()) {
                        d.acceptDrag(1);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void drop(DropTargetDropEvent d) {
            try {
                Transferable trans = d.getTransferable();
                DataFlavor[] flavors = trans.getTransferDataFlavors();
                int i = 0;
                while (i < flavors.length) {
                    if (flavors[i].isFlavorJavaFileListType()) {
                        d.acceptDrop(1);
                        List files = (List)trans.getTransferData(flavors[i]);
                        int anz = files.size();
                        int k = 0;
                        while (k < anz) {
                            File f = (File)files.get(k);
                            String ord = String.valueOf(f.getParent()) + Geopro.trenner;
                            String dat = f.getName();
                            if (dat.endsWith(".cas")) {
                                Ablage.oeffneCAS(ord, dat, false);
                                Geopro.algebraFenster.setTitle(dat);
                                Geopro.algebraFenster.setVisible(true);
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                Geopro.kommentieren("Drag and Drop gescheitert!");
            }
        }
    }

    class Lauf
    extends Thread
    implements Runnable {
        Lauf() {
        }

        @Override
        public void run() {
            AlgebraFenster.this.allesInterpretieren(AlgebraFenster.this.algebraEingabe.getText());
            lauf = null;
        }
    }
}

