/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;

class Grundriss
extends Bildriss {
    private static final long serialVersionUID = 1L;

    Grundriss() {
    }

    @Override
    Vektor2D rBildPunkt(Vektor3D p) {
        return new Vektor2D((double)X0 + faktor * p.y, (double)Y0 + faktor * p.x);
    }

    @Override
    Vektor2D bildPunkt(Vektor3D p) {
        return new Vektor2D(Skalar.runde((double)X0 + faktor * p.y), Skalar.runde((double)Y0 + faktor * p.x));
    }

    @Override
    void aktuell() {
        spezialRiss = 1;
        X0 = Geopro.mitteX / 2 + schX;
        Y0 = Geopro.mitteY / 2 + schY;
        kante = Geopro.kante;
        faktor = Geopro.faktor / 2.0;
        Geopro.blickrichtung = new Vektor3D(0.0, 0.0, 1.0);
    }

    @Override
    void achsenZeichnen(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(0.5f));
        switch (Geopro.hellHinten) {
            case 1: {
                g.setColor(Color.black);
                break;
            }
            case 0: {
                g.setColor(Color.white);
                break;
            }
            case 2: {
                g.setColor(Geopro.farbe[13]);
            }
        }
        Vektor3D o = new Vektor3D(0.0, 0.0, 0.0);
        Vektor3D x = new Vektor3D(Geopro.kante, 0.0, 0.0);
        Vektor3D y = new Vektor3D(0.0, Geopro.kante, 0.0);
        if (!Geopro.mitWuerfel) {
            this.linie3D(g, o, x);
            this.linie3D(g, o, y);
        }
        this.pfeil(g, o, x);
        this.pfeil(g, o, y);
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 2, 9));
        Vektor2D X = this.bildPunkt(x);
        Vektor2D Y = this.bildPunkt(y);
        g.drawString("x", X.X - 3, X.Y + 8);
        g.drawString("y", Y.X + 3, Y.Y + 2);
    }

    @Override
    void gitterZeichnen(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(0.25f));
        g.setColor(Geopro.gitter);
        double f = Geopro.faktor / 2.0;
        int B = this.getBounds().width;
        int H = this.getBounds().height;
        double L = (double)X0 - f * (double)((int)((double)X0 / f + 1.0));
        double R = (double)X0 + f * (double)((int)((double)(B - X0) / f + 1.0));
        double O = (double)Y0 - f * (double)((int)((double)Y0 / f + 1.0));
        double U = (double)Y0 + f * (double)((int)((double)(H - Y0) / f + 1.0));
        double x = L;
        while (x <= R) {
            g.draw(new Line2D.Double(x, 0.0, x, U));
            x += f;
        }
        double y = O;
        while (y <= U) {
            g.draw(new Line2D.Double(L, y, R, y));
            y += f;
        }
    }

    @Override
    boolean knopfSicht() {
        return false;
    }

    @Override
    String knopfText() {
        return "Grundriss";
    }

    public void zeichnen(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.aktuell();
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 10));
        g.setColor(Geopro.hinter);
        g.fillRect(0, 0, this.getBounds().width + 1, this.getBounds().height + 1);
        if (this.mit) {
            if (Geopro.mitGitter) {
                this.gitterZeichnen(g);
            }
            if (Geopro.mitWuerfel) {
                this.eckeZeichnen(g);
            }
            if (Geopro.mitAchsen) {
                this.achsenZeichnen(g);
            }
            this.objekteZeichnen(g, 1);
        }
        this.knopfZeichnen(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.zeichnen(g);
    }

    @Override
    void drehkippen(int X, int Y) {
    }

    void kontext() {
    }

    @Override
    void hilfsPunkt(int X, int Y) {
        Geopro.punkt[Punkt.max - 1].tripel = Punkt.nummer > -1 ? Geopro.punkt[Punkt.nummer].tripel : new Vektor3D((double)(Y - Y0) / faktor, (double)(X - X0) / faktor, 0.0);
    }

    @Override
    void festPunkt(int t, String n, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = Geopro.aktLayer;
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(100, n, "" + (double)(Y - Y0) / faktor, "" + (double)(X - X0) / faktor, "0.0", f, s, l, 0, 0);
    }

    @Override
    void basisPunkt(int t, String n, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = Geopro.aktLayer;
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(t, n, (double)(Y - Y0) / faktor, (double)(X - X0) / faktor, 0.0, f, s, l, 0, 0);
    }

    void gitterPunkt(int X, int Y) {
        Geopro.punkt[Punkt.nummer].neueWerte(Skalar.runde((double)(Y - Y0) / faktor), Skalar.runde((double)(X - X0) / faktor), Geopro.punkt[Punkt.nummer].tripel.z);
    }

    @Override
    void gleitPunkt(int t, String n, int g, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        Boolean ex = true;
        this.aktuell();
        Vektor3D p = new Vektor3D((double)(Y - Y0) / faktor, (double)(X - X0) / faktor, 0.0);
        int art = Geopro.gerade[g].art;
        if (art >= 4) {
            Vektor3D m = Geopro.gerade[g].tripel;
            Vektor3D v = Geopro.gerade[g].richtung;
            Vektor3D b = new Vektor3D(0.0, 0.0, 1.0);
            Ebene e = new Ebene(m, v);
            Gerade gb = new Gerade(p, b);
            Punkt s = new Punkt(e, gb, 0);
            if (s.exi) {
                p = s.tripel;
            } else {
                ex = false;
            }
        }
        if (ex.booleanValue()) {
            int f = Geopro.aktRand;
            int s = Geopro.aktStil;
            int[] l = new int[5];
            int i = 0;
            while (i < 5) {
                l[i] = Geopro.aktLayer[i];
                ++i;
            }
            Geopro.punkt[Punkt.nummer] = new Punkt(t, n, g, p.x, p.y, p.z, f, s, l, 0, 0);
        }
    }

    @Override
    void neuerBasisPunkt(boolean oben, int X, int Y) {
        this.aktuell();
        Geopro.punkt[Punkt.nummer].neueWerte((double)(Y - Y0) / faktor, (double)(X - X0) / faktor, Geopro.punkt[Punkt.nummer].tripel.z);
    }

    @Override
    void neuerGleitPunkt(int X, int Y) {
        boolean ex = true;
        this.aktuell();
        Vektor3D p = new Vektor3D((double)(Y - Y0) / faktor, (double)(X - X0) / faktor, 0.0);
        int nr = Geopro.punkt[Punkt.nummer].her1;
        if (nr >= 0) {
            int art = Geopro.gerade[nr].art;
            if (art >= 4) {
                Vektor3D m = Geopro.gerade[nr].tripel;
                Vektor3D v = Geopro.gerade[nr].richtung;
                Vektor3D b = new Vektor3D(0.0, 0.0, 1.0);
                Ebene e = new Ebene(m, v);
                Gerade gb = new Gerade(p, b);
                Punkt s = new Punkt(e, gb, 0);
                if (s.exi) {
                    p = s.tripel;
                } else {
                    ex = false;
                }
            }
        } else {
            ex = false;
        }
        if (ex) {
            Geopro.punkt[Punkt.nummer].neueWerte(p.x, p.y, p.z);
        }
    }

    @Override
    double neuerKreisradius3D(boolean ganz, int i, int j, double X, double Y) {
        this.aktuell();
        double r = 0.0;
        Vektor3D p = Geopro.punkt[i].tripel;
        Vektor3D q = new Vektor3D((Y - (double)Y0) / faktor, (X - (double)X0) / faktor, 0.0);
        Vektor3D en = Geopro.ebene[j].normale;
        double d = Vektor3D.skap(en, p);
        Ebene e = new Ebene(en, d);
        Vektor3D n = Geopro.blickrichtung;
        Gerade g = new Gerade(q, n);
        Punkt s = new Punkt(e, g, 0);
        if (s.exi) {
            q = s.tripel;
            r = Vektor3D.norm(Vektor3D.weg(p, q));
            r = ganz ? (double)Math.round(r) : Skalar.runder(r, Geopro.stellen);
        } else {
            r = Geopro.gerade[Gerade.nummer].radius;
        }
        return r;
    }

    @Override
    double neuerKugelradius(boolean ganz, int i, double X, double Y) {
        this.aktuell();
        double r = 0.0;
        Vektor3D p = Geopro.punkt[i].tripel;
        Vektor3D q = new Vektor3D((Y - (double)Y0) / faktor, (X - (double)X0) / faktor, p.z);
        r = Vektor3D.norm(Vektor3D.weg(p, q));
        r = ganz ? (double)Math.round(r) : Skalar.runder(r, Geopro.stellen);
        return r;
    }

    @Override
    void basisKugel(int t, String n, int p, int X, int Y, boolean ganz) {
        String rad = Attribute.paraEingabe.getText();
        int farbe = Geopro.aktRand;
        int[] layer = new int[5];
        int i = 0;
        while (i < 5) {
            layer[i] = Geopro.aktLayer[i];
            ++i;
        }
        if (Geopro.aktVoll > 0) {
            farbe += 100 * Geopro.aktFlaeche;
        }
        if (rad.length() > 0) {
            Geopro.ebene[Geopro.konstruktion[Konstruktion.nummer].ebenenZahl] = new Ebene(t, n, p, rad, farbe, Geopro.aktDicke, Geopro.aktStrich, Geopro.aktVoll, layer, 0, 0);
        } else {
            Geopro.aktLang = String.valueOf(this.neuerKugelradius(ganz, p, X, Y));
            Geopro.ebene[Geopro.konstruktion[Konstruktion.nummer].ebenenZahl] = new Ebene(t, n, p, Geopro.aktLang, farbe, Geopro.aktDicke, Geopro.aktStrich, Geopro.aktVoll, layer, 0, 0);
        }
    }
}

