/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

class Protokoll
extends Objektleiste {
    private static final long serialVersionUID = 1L;
    int zeile = -1;
    int laenge = 0;
    int stellen = 2;
    String name = "";
    boolean layerAnders = false;
    static int h = 16;
    static String fehler = " (FEHLER !)";

    Protokoll() {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Geopro.textBreite + 200, Geopro.konstruktion[Konstruktion.nummer].stand * h + 20);
    }

    void listeAnpassen() {
        if (Geopro.mitBericht) {
            Geopro.rollProtokoll.invalidate();
            Geopro.protokoll.repaint();
            int T = h * Geopro.konstruktion[Konstruktion.nummer].stand;
            Geopro.rollProtokoll.getViewport().setViewPosition(new Point(0, T));
            Geopro.rollProtokoll.validate();
            this.zeile = -1;
        }
    }

    static String textErzeugen() {
        String pfeil = "";
        String pfeil0 = "  \u21d2  ";
        String pfeil1 = "  ==>  ";
        pfeil = Geopro.osTyp == 0 ? pfeil0 : pfeil1;
        String proText = "";
        String proZeile = "";
        if (Geopro.mathetext == 1) {
            proText = Tex.kopf();
            pfeil = " $\\R$ ";
        }
        Schritt sch = new Schritt();
        if (Geopro.kurztext) {
            int i = 0;
            while (i < Geopro.konstruktion[Konstruktion.nummer].stand) {
                sch = Geopro.konstruktion[Konstruktion.nummer].schritt[i];
                int nr = sch.nummer;
                proZeile = "";
                switch (sch.art) {
                    case 1: {
                        proZeile = Geopro.punkt[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 2: {
                        proZeile = Geopro.gerade[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 3: {
                        proZeile = Geopro.vieleck[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 4: {
                        proZeile = Geopro.ebene[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 5: {
                        proZeile = Geopro.koerper[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 6: {
                        proZeile = Geopro.mass[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 7: {
                        proZeile = Geopro.abbild[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 8: {
                        proZeile = Geopro.marke[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 9: {
                        proZeile = Geopro.ortslinie[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                    }
                }
                proText = Geopro.mathetext == 1 ? String.valueOf(proText) + proZeile + "\\\\" + Geopro.cr : String.valueOf(proText) + proZeile + "\n\r";
                ++i;
            }
        } else {
            String name = "";
            int i = 0;
            while (i < Geopro.konstruktion[Konstruktion.nummer].stand) {
                sch = Geopro.konstruktion[Konstruktion.nummer].schritt[i];
                int nr = sch.nummer;
                switch (sch.art) {
                    case 1: {
                        name = Geopro.punkt[nr].name;
                        if (name.equals("_")) {
                            name = "P." + nr;
                        }
                        proZeile = Geopro.punkt[nr].bericht(Geopro.punkt[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.punkt[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 2: {
                        name = Geopro.gerade[nr].name;
                        if (name.equals("_")) {
                            name = "L." + nr;
                        }
                        proZeile = Geopro.gerade[nr].bericht(Geopro.gerade[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.gerade[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 3: {
                        name = Geopro.vieleck[nr].name;
                        if (name.equals("_")) {
                            name = "V." + nr;
                        }
                        proZeile = Geopro.vieleck[nr].bericht(Geopro.vieleck[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.vieleck[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 4: {
                        name = Geopro.ebene[nr].name;
                        if (name.equals("_")) {
                            name = "F." + nr;
                        }
                        proZeile = Geopro.ebene[nr].bericht(Geopro.ebene[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.ebene[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 5: {
                        name = Geopro.koerper[nr].name;
                        if (name.equals("_")) {
                            name = "S." + nr;
                        }
                        proZeile = Geopro.koerper[nr].bericht(Geopro.koerper[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.koerper[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 6: {
                        name = Geopro.mass[nr].name;
                        if (name.equals("_")) {
                            name = "M." + nr;
                        }
                        proZeile = Geopro.mass[nr].bericht(Geopro.mass[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.mass[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 7: {
                        name = Geopro.abbild[nr].name;
                        if (name.equals("_")) {
                            name = "A." + nr;
                        }
                        proZeile = Geopro.abbild[nr].bericht(Geopro.abbild[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.abbild[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 8: {
                        name = Geopro.marke[nr].text;
                        if (name.equals("_")) {
                            name = "T." + nr;
                        }
                        proZeile = Geopro.marke[nr].bericht(Geopro.marke[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.marke[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 9: {
                        name = Geopro.ortslinie[nr].name;
                        if (name.equals("_")) {
                            name = "K." + nr;
                        }
                        proZeile = Geopro.ortslinie[nr].bericht(Geopro.ortslinie[nr].typ, name);
                        proZeile = String.valueOf(proZeile) + pfeil + Geopro.ortslinie[nr].analytisch(Geopro.mathetext, Geopro.exakt, nr);
                        break;
                    }
                    case 10: {
                        name = Geopro.gebiet[nr].name;
                        if (name.equals("_")) {
                            name = "G." + nr;
                        }
                        proZeile = Geopro.gebiet[nr].bericht(Geopro.gebiet[nr].typ, name);
                    }
                }
                if (Geopro.mathetext == 1) {
                    proZeile = proZeile.replace("\u03b1", "$\\alpha$");
                    proZeile = proZeile.replace("\u03b2", "$\\beta$");
                    proZeile = proZeile.replace("\u03b3", "$\\gamma$");
                    proZeile = proZeile.replace("\u03b4", "$\\delta$");
                    proZeile = proZeile.replace("\u03b5", "$\\varepsilon$");
                    proZeile = proZeile.replace("\u03bc", "$\\mue$");
                    proZeile = proZeile.replace("\u03c3", "$\\varsigma$");
                    proText = String.valueOf(proText) + proZeile + "\\\\" + Geopro.cr;
                } else {
                    proText = String.valueOf(proText) + proZeile + "\n\r";
                }
                ++i;
            }
        }
        if (Geopro.mathetext == 1) {
            proText = String.valueOf(proText) + "\\end{document}" + Geopro.cr;
        }
        return proText;
    }

    static void einsetzen() {
        Geopro.analytAusgabe.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, Geopro.schriftgross[Geopro.schriftGross] + 1));
        Geopro.analytAusgabe.setText(Protokoll.textErzeugen());
    }

    @Override
    public void paintComponent(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String proZeile = "";
        Schritt sch = new Schritt();
        this.laenge = Geopro.konstruktion[Konstruktion.nummer].stand * h;
        Geopro.rollProtokoll.setBackground(Color.white);
        int b = this.getBounds().width;
        int f1 = 255;
        int f2 = 245;
        int f3 = 235;
        int f4 = 205;
        Color farbe1 = new Color(f3, f3, f3);
        Color farbe2 = new Color(f2, f2, f2);
        Color farbe3 = new Color(f4, f4, f4);
        g.setColor(new Color(f1, f1, f1));
        g.fillRect(-5, -5, b + 5, this.getBounds().height + 5);
        if (this.zeile >= 0) {
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, this.zeile * h, b, h - 1);
            GradientPaint gp = new GradientPaint(b / 2, this.zeile * h, farbe1, b / 2, this.zeile * h + h, farbe1, true);
            g.setPaint(gp);
            g.fill(rect);
        }
        boolean def = false;
        boolean exi = false;
        boolean gef = false;
        boolean mar = false;
        int rand = 0;
        int flaeche = 0;
        int voll = 0;
        int[] layer = new int[5];
        int j = 0;
        while (j < 5) {
            layer[j] = 0;
            ++j;
        }
        boolean lay = false;
        boolean zentral = true;
        String name = "";
        String txt = "";
        int bNr = 0;
        int i = 0;
        while (i < Geopro.konstruktion[Konstruktion.nummer].stand) {
            zentral = true;
            sch = Geopro.konstruktion[Konstruktion.nummer].schritt[i];
            int nr = sch.nummer;
            switch (sch.art) {
                case 1: {
                    name = Geopro.punkt[nr].name;
                    if (name.equals("_")) {
                        name = "P." + nr;
                    }
                    sch.text = Geopro.punkt[nr].bericht(Geopro.punkt[nr].typ, name);
                    rand = Geopro.punkt[nr].farbe % 100;
                    flaeche = 0;
                    voll = 0;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.punkt[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.punkt[nr].def;
                    exi = Geopro.punkt[nr].exi;
                    gef = nr == Punkt.nummer;
                    mar = Geopro.punkt[nr].gefangen || nr == Punkt.markiert;
                    lay = Geopro.punkt[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 2: {
                    name = Geopro.gerade[nr].name;
                    if (name.equals("_")) {
                        name = "L." + nr;
                    }
                    sch.text = Geopro.gerade[nr].bericht(Geopro.gerade[nr].typ, name);
                    rand = Geopro.gerade[nr].farbe % 100;
                    if (Geopro.gerade[nr].typ >= 220) {
                        if (Geopro.projektionsArt > Geopro.projektionsNiveau) {
                            zentral = false;
                        }
                        flaeche = Geopro.gerade[nr].farbe / 100;
                        voll = Geopro.gerade[nr].voll;
                    } else {
                        flaeche = 0;
                        voll = 0;
                    }
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.gerade[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.gerade[nr].def;
                    exi = Geopro.gerade[nr].exi;
                    gef = nr == Gerade.nummer || nr == Gerade.nummer2;
                    mar = Geopro.gerade[nr].gefangen || nr == Gerade.markiert || nr == Gerade.markiert2;
                    lay = Geopro.gerade[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 3: {
                    name = Geopro.vieleck[nr].name;
                    if (name.equals("_")) {
                        name = "V." + nr;
                    }
                    sch.text = Geopro.vieleck[nr].bericht(Geopro.vieleck[nr].typ, name);
                    rand = Geopro.vieleck[nr].farbe % 100;
                    flaeche = Geopro.vieleck[nr].farbe / 100;
                    voll = Geopro.vieleck[nr].art == 5 ? 0 : Geopro.vieleck[nr].voll;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.vieleck[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.vieleck[nr].def;
                    exi = Geopro.vieleck[nr].exi;
                    gef = nr == Vieleck.nummer;
                    mar = Geopro.vieleck[nr].gefangen || nr == Vieleck.markiert;
                    lay = Geopro.vieleck[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 4: {
                    name = Geopro.ebene[nr].name;
                    if (name.equals("_")) {
                        name = "F." + nr;
                    }
                    sch.text = Geopro.ebene[nr].bericht(Geopro.ebene[nr].typ, name);
                    if (Geopro.ebene[nr].typ >= 420 && Geopro.projektionsArt > Geopro.projektionsNiveau) {
                        zentral = false;
                    }
                    rand = Geopro.ebene[nr].farbe % 100;
                    flaeche = Geopro.ebene[nr].farbe / 100;
                    voll = Geopro.ebene[nr].voll;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.ebene[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.ebene[nr].def;
                    exi = Geopro.ebene[nr].exi;
                    gef = nr == Ebene.nummer;
                    mar = Geopro.ebene[nr].gefangen || nr == Ebene.markiert;
                    lay = Geopro.ebene[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 5: {
                    name = Geopro.koerper[nr].name;
                    if (name.equals("_")) {
                        name = "S." + nr;
                    }
                    sch.text = Geopro.koerper[nr].bericht(Geopro.koerper[nr].typ, name);
                    rand = Geopro.koerper[nr].farbe % 100;
                    flaeche = Geopro.koerper[nr].farbe / 100;
                    voll = Geopro.koerper[nr].voll;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.koerper[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.koerper[nr].def;
                    exi = Geopro.koerper[nr].exi;
                    gef = nr == Koerper.nummer;
                    mar = Geopro.koerper[nr].gefangen || nr == Koerper.markiert;
                    lay = Geopro.koerper[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 6: {
                    name = Geopro.mass[nr].name;
                    if (name.equals("_")) {
                        name = "M." + nr;
                    }
                    sch.text = Geopro.mass[nr].bericht(Geopro.mass[nr].typ, name);
                    rand = Geopro.mass[nr].farbe % 100;
                    flaeche = Geopro.mass[nr].farbe / 100;
                    voll = Geopro.mass[nr].voll;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.mass[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.mass[nr].def;
                    exi = Geopro.mass[nr].exi;
                    gef = nr == Messen.nummer;
                    mar = nr == Messen.markiert;
                    lay = Geopro.mass[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 7: {
                    name = Geopro.abbild[nr].name;
                    if (name.equals("_")) {
                        name = "A." + nr;
                    }
                    sch.text = Geopro.abbild[nr].bericht(Geopro.abbild[nr].typ, name);
                    rand = Geopro.abbild[nr].farbe % 100;
                    flaeche = 0;
                    voll = 0;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.abbild[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.abbild[nr].def;
                    exi = Geopro.abbild[nr].exi;
                    gef = nr == Abbild.nummer;
                    mar = Geopro.abbild[nr].gefangen || nr == Abbild.markiert;
                    lay = Geopro.abbild[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 8: {
                    name = Geopro.marke[nr].text;
                    if (name.equals("_")) {
                        name = "T." + nr;
                    }
                    sch.text = Geopro.marke[nr].bericht(Geopro.marke[nr].typ, name);
                    rand = Geopro.marke[nr].farbe % 100;
                    flaeche = Geopro.marke[nr].farbe / 100;
                    voll = Geopro.marke[nr].voll;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.marke[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.marke[nr].def;
                    exi = Geopro.marke[nr].exi;
                    gef = nr == Marke.nummer;
                    mar = nr == Marke.markiert;
                    lay = Geopro.marke[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 9: {
                    name = Geopro.ortslinie[nr].name;
                    if (name.equals("_")) {
                        name = "K." + nr;
                    }
                    sch.text = Geopro.ortslinie[nr].bericht(Geopro.ortslinie[nr].typ, name);
                    rand = Geopro.ortslinie[nr].farbe % 100;
                    if (Geopro.ortslinie[nr].typ == 900 || Geopro.ortslinie[nr].typ == 904) {
                        flaeche = Geopro.ortslinie[nr].farbe / 100;
                        voll = Geopro.ortslinie[nr].voll;
                    } else {
                        flaeche = 0;
                        voll = 0;
                    }
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.ortslinie[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.ortslinie[nr].def;
                    exi = Geopro.ortslinie[nr].exi;
                    gef = nr == Ortslinie.nummer;
                    mar = Geopro.ortslinie[nr].gefangen || nr == Ortslinie.markiert;
                    lay = Geopro.ortslinie[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                    break;
                }
                case 10: {
                    name = Geopro.gebiet[nr].name;
                    if (name.equals("_")) {
                        name = "G." + nr;
                    }
                    sch.text = Geopro.gebiet[nr].bericht(Geopro.gebiet[nr].typ, name);
                    rand = Geopro.gebiet[nr].farbe % 100;
                    flaeche = Geopro.gebiet[nr].farbe / 100;
                    voll = Geopro.gebiet[nr].voll;
                    int j2 = 0;
                    while (j2 < 5) {
                        layer[j2] = Geopro.gebiet[nr].layer[j2];
                        ++j2;
                    }
                    def = Geopro.gebiet[nr].def;
                    exi = Geopro.gebiet[nr].exi;
                    gef = nr == Gebiet.nummer;
                    mar = Geopro.gebiet[nr].gefangen || nr == Gebiet.markiert;
                    lay = Geopro.gebiet[nr].maxLayer() >= 0;
                    txt = "" + nr;
                    bNr = Operationsleiste.bildNummer(sch.typ);
                }
            }
            rand = Math.abs(rand);
            flaeche = Math.abs(flaeche);
            if (mar) {
                GradientPaint gp1 = new GradientPaint(b / 2, i * h, farbe2, b / 2, i * h + h, farbe3, true);
                g.setPaint(gp1);
                g.fillRect(0, i * h, b, h);
            } else if (gef) {
                GradientPaint gp1 = new GradientPaint(b / 2, i * h, farbe1, b / 2, i * h + h, farbe1, true);
                g.setPaint(gp1);
                g.fillRect(0, i * h, b, h);
            }
            if (!def) {
                g.setFont(new Font("Arial", 2, 11));
                proZeile = sch.text;
            } else if (!exi || !lay) {
                g.setFont(new Font("Arial", 0, 11));
                proZeile = sch.text;
            } else if (def && exi) {
                g.setFont(new Font("Arial", 1, 11));
                proZeile = sch.text;
            }
            int ss = 13;
            int zn = 0;
            int os = 0;
            int as = 0;
            int l = 1;
            int r = 4;
            if (rand == 10 || rand == 11) {
                g.setColor(Color.black);
            }
            g.setStroke(new BasicStroke(1.0f));
            if (Geopro.mitZeilennummern) {
                g.setColor(Color.gray);
                g.drawString(String.valueOf(this.zeilennummer(i)) + ":", 2, h * (i + 1) - 5);
                zn = 25;
            }
            if (Geopro.mitOpsSymbolen) {
                g.setColor(new Color(240, 240, 240));
                g.fillRoundRect(l + zn, h * i + 1, ss, ss, r, r);
                g.drawImage(Geopro.bild[sch.art][bNr], l + zn + 1, h * i + 2, 12, 12, this);
                g.setColor(Color.gray);
                g.drawRoundRect(l + zn, h * i + 1, ss, ss, r, r);
                os = ss + 2;
            }
            if (Geopro.mitAttSymbolen) {
                int j3;
                if (voll == 0) {
                    if (rand == 10 || rand == 11) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Geopro.farbe[rand]);
                    }
                    g.drawRoundRect(l + zn + os, h * i + 1, ss, ss, r, r);
                    g.setStroke(new BasicStroke(0.5f));
                    j3 = 0;
                    while (j3 < 5) {
                        if (layer[j3] == 1) {
                            g.draw(new Line2D.Double(l + zn + os + 2, (double)(h * i + 11 - 2 * j3) + 0.5, l + zn + os + ss - 2, (double)(h * i + 11 - 2 * j3) + 0.5));
                        }
                        ++j3;
                    }
                } else {
                    if (flaeche > 0) {
                        float tp = Attribute.transparenz(voll);
                        Color c = Geopro.farbe[flaeche];
                        g.setColor(new Color((float)((double)c.getRed() / 255.0), (float)((double)c.getGreen() / 255.0), (float)((double)c.getBlue() / 255.0), tp));
                        g.fillRoundRect(l + zn + os, h * i + 1, ss, ss, r, r);
                    }
                    if (rand == 10 || rand == 11) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Geopro.farbe[rand]);
                    }
                    g.drawRoundRect(l + zn + os, h * i + 1, ss, ss, r, r);
                    g.setStroke(new BasicStroke(0.5f));
                    j3 = 0;
                    while (j3 < 5) {
                        if (layer[j3] == 1) {
                            g.draw(new Line2D.Double(l + zn + os + 2, h * i + 11 - 2 * j3, l + zn + os + ss - 2, h * i + 11 - 2 * j3));
                        }
                        ++j3;
                    }
                    if (flaeche == 11) {
                        g.draw(new Line2D.Double(l + zn + os + 3, h * i + 2, l + zn + os + 1, h * i + 4));
                    }
                }
                as = ss + 2;
            }
            if (rand == 0 && flaeche == 0) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(proZeile, l + zn + os + as + 2, h * (i + 1) - 5);
            g.setColor(new Color(f3, f3, f3));
            g.drawLine(0, h * (i + 1) - 1, b, h * (i + 1) - 1);
            g.setColor(Geopro.farbe[rand]);
            g.setFont(new Font("Arial", 1, 9));
            if (rand == Geopro.ausFarbe || flaeche == Geopro.ausFarbe) {
                g.drawString("J", l + zn + os + 3, h * i + 11);
            } else if (!def) {
                g.drawString("X", l + zn + os + 4, h * i + 11);
            } else if (!exi) {
                g.drawString("N", l + zn + os + 4, h * i + 11);
            } else if (!lay) {
                g.setColor(Geopro.farbe[0]);
                g.drawString("L", l + zn + os + 4, h * i + 11);
            }
            ++i;
        }
    }

    String zeilennummer(int i) {
        int j = i + 1;
        if (j < 10) {
            return "00" + j;
        }
        if (j < 100) {
            return "0" + j;
        }
        return "" + j;
    }

    static String eingabe() {
        String ein = Attribute.nameEingabe.getText();
        if (ein.length() == 0) {
            ein = "_";
        }
        return ein;
    }

    void ausfuehren(boolean shift, boolean alt) {
        if (Messen.fangzahl == 0 && Punkt.fangzahl == 0 && Gerade.fangzahl == 0 && Vieleck.fangzahl == 0 && Ebene.fangzahl == 0 && Koerper.fangzahl == 0 && Abbild.fangzahl == 0 && Ortslinie.fangzahl == 0 && Gebiet.fangzahl == 0) {
            if (Geopro.objektModus <= 0 && (Geopro.objektArt != 1 || Geopro.punktModus > 102)) {
                Geopro.bildtafel.operation(shift, alt, Protokoll.eingabe(), 0, 0);
            }
            if (Geopro.objektArt > 0) {
                this.listeAnpassen();
            }
        }
        Geopro.neuZeichnen();
        Geopro.unsauber();
    }

    void neuFangen() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        Messen.nummer = -1;
        Punkt.nummer = -1;
        Gerade.nummer = -1;
        Vieleck.nummer = -1;
        Ebene.nummer = -1;
        Koerper.nummer = -1;
        Abbild.nummer = -1;
        Marke.nummer = -1;
        Ortslinie.nummer = -1;
        Gebiet.nummer = -1;
        Geopro.neuZeichnen();
    }

    String objektName(String name, int nr, char z) {
        String n = "";
        n = !name.equals("_") ? name : String.valueOf(z) + "." + nr;
        return n;
    }

    void fangen(int nr) {
        String name = "";
        int a = Geopro.konstruktion[Konstruktion.nummer].schritt[nr].art;
        int i = Geopro.konstruktion[Konstruktion.nummer].schritt[nr].nummer;
        Geopro.bildtafel.paraFangen();
        boolean objArt = Geopro.objektArt == 0 && Geopro.objektModus == 0;
        boolean objMod = Geopro.objektModus >= 1 && Geopro.objektModus <= 7;
        switch (a) {
            case 1: {
                if (objArt || objMod || Punkt.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Punkt.nummer = i;
                    name = this.objektName(Geopro.punkt[i].name, i, 'P');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 2: {
                if (objArt || objMod || Gerade.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Gerade.nummer = i;
                    name = this.objektName(Geopro.gerade[i].name, i, 'L');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 3: {
                if (objArt || objMod || Vieleck.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Vieleck.nummer = i;
                    name = this.objektName(Geopro.vieleck[i].name, i, 'V');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 4: {
                if (objArt || objMod || Ebene.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Ebene.nummer = i;
                    name = this.objektName(Geopro.ebene[i].name, i, 'F');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 5: {
                if (objArt || objMod || Koerper.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Koerper.nummer = i;
                    name = this.objektName(Geopro.koerper[i].name, i, 'S');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 6: {
                if (objArt || objMod || Messen.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Messen.nummer = i;
                    name = this.objektName(Geopro.mass[i].name, i, 'M');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 7: {
                if (objArt || objMod || Abbild.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Abbild.nummer = i;
                    name = this.objektName(Geopro.abbild[i].name, i, 'A');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 8: {
                if (objArt || objMod || Marke.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Marke.nummer = i;
                    name = this.objektName(Geopro.marke[i].text, i, 'T');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 9: {
                if (objArt || objMod || Ortslinie.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Ortslinie.nummer = i;
                    name = this.objektName(Geopro.ortslinie[i].name, i, 'K');
                    break;
                }
                this.zeile = -1;
                break;
            }
            case 10: {
                if (objArt || objMod || Gebiet.fangzahl > 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Gebiet.nummer = i;
                    name = this.objektName(Geopro.gebiet[i].name, i, 'G');
                    break;
                }
                this.zeile = -1;
            }
        }
        if (Geopro.objektArt > 0) {
            Infoleiste.infoZeile = Geopro.objektWuensche;
        } else if (a > 0) {
            Infoleiste.infoZeile = "Objekt '" + name + "' gefangen";
        }
    }

    void fehlerMeldung() {
        Attribute.paraEingabe.requestFocus();
        Attribute.paraEingabe.selectAll();
        Geopro.beep();
    }

    void punktAnders1() {
        Geopro.punkt[Punkt.nummer].name = Protokoll.eingabe();
        Bildtafel.eingabeLeeren();
    }

    int umDef(int f) {
        int ff = f;
        ff = f == 0 ? -20 : (f == -20 ? 0 : -f);
        return ff;
    }

    void punktAnders2(boolean alle) {
        block5: {
            block4: {
                if (!alle) break block4;
                int i = 0;
                while (i < Geopro.konstruktion[Konstruktion.nummer].punktZahl) {
                    Geopro.punkt[i].farbe = Geopro.aktRand;
                    Geopro.punkt[i].stil = Geopro.aktStil % 10 + 10 * Geopro.aktFuss;
                    if (this.layerAnders) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.punkt[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                    }
                    ++i;
                }
                break block5;
            }
            Geopro.punkt[Punkt.nummer].farbe = Geopro.aktRand;
            Geopro.punkt[Punkt.nummer].stil = Geopro.aktStil % 10 + 10 * Geopro.aktFuss;
            if (!this.layerAnders) break block5;
            int j = 0;
            while (j < 5) {
                Geopro.punkt[Punkt.nummer].layer[j] = Geopro.aktLayer[j];
                ++j;
            }
        }
    }

    void punktAnders3(boolean alle) {
        if (alle) {
            int i = 0;
            while (i < Geopro.konstruktion[Konstruktion.nummer].punktZahl) {
                Geopro.punkt[i].farbe = 0;
                ++i;
            }
        } else {
            Geopro.punkt[Punkt.nummer].farbe = 0;
        }
    }

    void punktAnders4() {
        int f;
        int nr = Punkt.nummer;
        Geopro.punkt[nr].farbe = f = this.umDef(Geopro.punkt[nr].farbe);
        Geopro.punkt[nr].def = f >= 0;
    }

    void punktAnders5(boolean alle) {
        if (alle) {
            int i = 0;
            while (i < Geopro.konstruktion[Konstruktion.nummer].punktZahl) {
                int j = 0;
                while (j < 5) {
                    Geopro.punkt[i].layer[j] = Geopro.aktLayer[j];
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < 5) {
                Geopro.punkt[Punkt.nummer].layer[j] = Geopro.aktLayer[j];
                ++j;
            }
        }
    }

    void punktAnders6() {
        Attribute.markierungenEntfernen();
        Punkt.markiert = Punkt.nummer;
        this.name = Geopro.punkt[Punkt.nummer].name;
        if (this.name.equals("_")) {
            this.name = "";
        }
        Attribute.nameEingabe.setText(this.name);
        int f = Geopro.punkt[Punkt.nummer].farbe % 100;
        Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
        Geopro.aktStil = Geopro.punkt[Punkt.nummer].stil % 10;
        Geopro.aktFuss = Geopro.punkt[Punkt.nummer].stil / 10;
        int j = 0;
        while (j < 5) {
            Geopro.aktLayer[j] = Geopro.punkt[Punkt.nummer].layer[j];
            ++j;
        }
        Attribute.def.setSelected(Geopro.punkt[Punkt.nummer].def);
        String lab = "";
        String txt = "";
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        this.stellen = Geopro.stellen;
        switch (Geopro.punkt[Punkt.nummer].typ) {
            case 100: {
                lab = "x,y =";
                mitParameter = true;
                if (Geopro.dimension == 2) {
                    txt = String.valueOf(Geopro.punkt[Punkt.nummer].xs) + ", " + Geopro.punkt[Punkt.nummer].ys;
                    break;
                }
                lab = "x,y,z =";
                txt = String.valueOf(Geopro.punkt[Punkt.nummer].xs) + ", " + Geopro.punkt[Punkt.nummer].ys + ", " + Geopro.punkt[Punkt.nummer].zs;
                break;
            }
            case 101: {
                lab = "x,y =";
                mitParameter = true;
                if (Geopro.dimension == 2) {
                    txt = String.valueOf(Skalar.runde(Geopro.punkt[Punkt.nummer].tripel.x, this.stellen)) + ", " + Skalar.runde(Geopro.punkt[Punkt.nummer].tripel.y, this.stellen);
                    break;
                }
                lab = "x,y,z =";
                txt = String.valueOf(Skalar.runde(Geopro.punkt[Punkt.nummer].tripel.x, this.stellen)) + ", " + Skalar.runde(Geopro.punkt[Punkt.nummer].tripel.y, this.stellen) + ", " + Skalar.runde(Geopro.punkt[Punkt.nummer].tripel.z, this.stellen);
                break;
            }
            case 102: {
                int art = Geopro.punkt[Punkt.nummer].art;
                lab = "Parameter =";
                mitParameter = true;
                mitAnzeige = true;
                if (art == 2 || art >= 4) {
                    txt = Skalar.runde(Geopro.punkt[Punkt.nummer].s, this.stellen);
                    break;
                }
                txt = Skalar.runde(Geopro.punkt[Punkt.nummer].t, this.stellen);
                break;
            }
            case 129: {
                int art = Geopro.punkt[Punkt.nummer].art;
                lab = "Parameter =";
                mitParameter = true;
                mitAnzeige = true;
                if (art == 8) {
                    txt = Skalar.runde(Geopro.punkt[Punkt.nummer].s, this.stellen);
                    break;
                }
                txt = Skalar.runde(Geopro.punkt[Punkt.nummer].t, this.stellen);
                break;
            }
            case 123: {
                lab = "Distanz =";
                mitParameter = true;
                mitAnzeige = true;
                txt = Geopro.punkt[Punkt.nummer].abTerm;
                break;
            }
            case 124: {
                lab = "Winkel [" + Geopro.grad + "] =";
                mitParameter = true;
                mitAnzeige = true;
                txt = Geopro.punkt[Punkt.nummer].anTerm;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
        Attribute.attributgraphik.repaint();
    }

    void punktAnders7() {
        int f = Geopro.punkt[Punkt.nummer].farbe % 100;
        Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
        Geopro.aktStil = Geopro.punkt[Punkt.nummer].stil % 10;
        Geopro.aktFuss = Geopro.punkt[Punkt.nummer].stil / 10;
        Attribute.attributgraphik.repaint();
        int j = 0;
        while (j < 5) {
            Geopro.aktLayer[j] = Geopro.punkt[Punkt.nummer].layer[j];
            ++j;
        }
    }

    void punktAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        switch (Geopro.objektModus) {
            case 1: {
                this.punktAnders1();
                break;
            }
            case 2: {
                this.punktAnders2(alle);
                break;
            }
            case 3: {
                this.punktAnders3(alle);
                break;
            }
            case 4: {
                this.punktAnders4();
                break;
            }
            case 5: {
                this.punktAnders5(alle);
                break;
            }
            case 6: {
                this.punktAnders6();
                break;
            }
            case 7: {
                this.punktAnders7();
            }
        }
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void geradeAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        boolean mitRegress = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.gerade[Gerade.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].geradenZahl) {
                        Geopro.gerade[i].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                        Geopro.gerade[i].dicke = Geopro.aktDicke;
                        Geopro.gerade[i].strich = Geopro.aktStrich + 10 * Geopro.aktPfeil;
                        Geopro.gerade[i].voll = Geopro.aktVoll;
                        if (this.layerAnders) {
                            int j = 0;
                            while (j < 5) {
                                Geopro.gerade[i].layer[j] = Geopro.aktLayer[j];
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    Geopro.gerade[Gerade.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                    Geopro.gerade[Gerade.nummer].dicke = Geopro.aktDicke;
                    Geopro.gerade[Gerade.nummer].strich = Geopro.aktStrich + 10 * Geopro.aktPfeil;
                    Geopro.gerade[Gerade.nummer].voll = Geopro.aktVoll;
                    if (!this.layerAnders) break;
                    int j = 0;
                    while (j < 5) {
                        Geopro.gerade[Gerade.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].geradenZahl) {
                        Geopro.gerade[i].farbe = 0;
                        Geopro.gerade[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.gerade[Gerade.nummer].farbe = 0;
                Geopro.gerade[Gerade.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.gerade[Gerade.nummer].farbe = f = this.umDef(Geopro.gerade[Gerade.nummer].farbe);
                if (f >= 0) {
                    Geopro.gerade[Gerade.nummer].def = true;
                    break;
                }
                Geopro.gerade[Gerade.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].geradenZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.gerade[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.gerade[Gerade.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Gerade.markiert = Gerade.nummer;
                this.name = Geopro.gerade[Gerade.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.gerade[Gerade.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.gerade[Gerade.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.gerade[Gerade.nummer].dicke;
                Geopro.aktStrich = Geopro.gerade[Gerade.nummer].strich % 10;
                Geopro.aktPfeil = Geopro.gerade[Gerade.nummer].strich / 10;
                Geopro.aktVoll = Geopro.gerade[Gerade.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.gerade[Gerade.nummer].layer[j];
                    ++j;
                }
                if (Geopro.gerade[Gerade.nummer].typ < 220) {
                    Geopro.aktFlaeche = 0;
                    Geopro.aktVoll = 0;
                }
                Attribute.def.setSelected(Geopro.gerade[Gerade.nummer].def);
                String lab = "";
                String txt = "";
                switch (Geopro.gerade[Gerade.nummer].typ) {
                    case 202: {
                        int her2 = Geopro.gerade[Gerade.nummer].her2;
                        if (Geopro.punkt[her2].typ != 101) break;
                        lab = "L\u00e4nge:";
                        double l = Vektor3D.norm(Geopro.gerade[Gerade.nummer].richtung);
                        txt = Skalar.runde(l, Geopro.stellen);
                        Attribute.zeig.setSelected(true);
                        mitParameter = true;
                        mitAnzeige = true;
                        break;
                    }
                    case 218: {
                        lab = "y(x) = mx+q =";
                        txt = Geopro.gerade[Gerade.nummer].term;
                        mitParameter = true;
                        break;
                    }
                    case 219: {
                        Geopro.analytModus = true;
                        Geopro.objektLeiste.analytisch(3, Gerade.nummer);
                        break;
                    }
                    case 220: {
                        lab = "Radius = ";
                        txt = String.valueOf(Geopro.gerade[Gerade.nummer].radTerm);
                        mitParameter = true;
                        mitAnzeige = true;
                        break;
                    }
                    case 225: {
                        if (Geopro.dimension != 2) break;
                        lab = "Quotient = ";
                        txt = String.valueOf(Geopro.gerade[Gerade.nummer].radTerm);
                        mitParameter = true;
                        mitAnzeige = true;
                        break;
                    }
                    case 227: 
                    case 228: 
                    case 232: {
                        lab = "Winkel [" + Geopro.grad + "] =";
                        txt = String.valueOf(Geopro.gerade[Gerade.nummer].winkTerm);
                        mitParameter = true;
                        mitAnzeige = true;
                        break;
                    }
                    case 229: {
                        Geopro.analytModus = true;
                        Geopro.objektLeiste.analytisch(5, Gerade.nummer);
                        break;
                    }
                    case 234: {
                        lab = "Radius =";
                        txt = String.valueOf(Geopro.gerade[Gerade.nummer].radTerm);
                        mitParameter = true;
                        mitAnzeige = true;
                        break;
                    }
                    case 238: {
                        lab = "Regression:";
                        mitRegress = true;
                        Attribute.regressWahl.setSelectedIndex(Geopro.gerade[Gerade.nummer].ops);
                    }
                }
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, mitRegress, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.gerade[Gerade.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.gerade[Gerade.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.gerade[Gerade.nummer].dicke;
                Geopro.aktStrich = Geopro.gerade[Gerade.nummer].strich % 10;
                Geopro.aktPfeil = Geopro.gerade[Gerade.nummer].strich / 10;
                Geopro.aktVoll = Geopro.gerade[Gerade.nummer].voll;
                if (Geopro.gerade[Gerade.nummer].typ < 220) {
                    Geopro.aktFlaeche = 0;
                    Geopro.aktVoll = 0;
                }
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.gerade[Gerade.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void vieleckAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.vieleck[Vieleck.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].vieleckZahl) {
                        Geopro.vieleck[i].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                        Geopro.vieleck[i].dicke = Geopro.aktDicke;
                        Geopro.vieleck[i].strich = Geopro.aktStrich;
                        Geopro.vieleck[i].voll = Geopro.aktVoll;
                        if (this.layerAnders) {
                            int j = 0;
                            while (j < 5) {
                                Geopro.vieleck[i].layer[j] = Geopro.aktLayer[j];
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    Geopro.vieleck[Vieleck.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                    Geopro.vieleck[Vieleck.nummer].dicke = Geopro.aktDicke;
                    Geopro.vieleck[Vieleck.nummer].strich = Geopro.aktStrich;
                    Geopro.vieleck[Vieleck.nummer].voll = Geopro.aktVoll;
                    if (!this.layerAnders) break;
                    int j = 0;
                    while (j < 5) {
                        Geopro.vieleck[Vieleck.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].vieleckZahl) {
                        Geopro.vieleck[i].farbe = 0;
                        Geopro.vieleck[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.vieleck[Vieleck.nummer].farbe = 0;
                Geopro.vieleck[Vieleck.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.vieleck[Vieleck.nummer].farbe = f = this.umDef(Geopro.vieleck[Vieleck.nummer].farbe);
                if (f >= 0) {
                    Geopro.vieleck[Vieleck.nummer].def = true;
                    break;
                }
                Geopro.vieleck[Vieleck.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].vieleckZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.vieleck[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.vieleck[Vieleck.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Vieleck.markiert = Vieleck.nummer;
                this.name = Geopro.vieleck[Vieleck.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.vieleck[Vieleck.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.vieleck[Vieleck.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.vieleck[Vieleck.nummer].dicke;
                Geopro.aktStrich = Geopro.vieleck[Vieleck.nummer].strich;
                Geopro.aktVoll = Geopro.vieleck[Vieleck.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.vieleck[Vieleck.nummer].layer[j];
                    ++j;
                }
                Attribute.def.setSelected(Geopro.vieleck[Vieleck.nummer].def);
                String lab = "";
                String txt = "";
                switch (Geopro.vieleck[Vieleck.nummer].typ) {
                    case 305: {
                        lab = "S,S,S; Winkel =";
                        mitParameter = true;
                        mitAnzeige = true;
                        String a = Geopro.vieleck[Vieleck.nummer].a;
                        String b = Geopro.vieleck[Vieleck.nummer].b;
                        String c = Geopro.vieleck[Vieleck.nummer].c;
                        String w = Geopro.vieleck[Vieleck.nummer].phi;
                        txt = String.valueOf(a) + "," + b + "," + c + ";" + w;
                        break;
                    }
                    case 308: {
                        lab = "S,W,S; Winkel =";
                        mitParameter = true;
                        mitAnzeige = true;
                        String a = Geopro.vieleck[Vieleck.nummer].a;
                        String psi = Geopro.vieleck[Vieleck.nummer].psi;
                        String c = Geopro.vieleck[Vieleck.nummer].c;
                        String w = Geopro.vieleck[Vieleck.nummer].phi;
                        txt = String.valueOf(a) + "," + psi + "," + c + ";" + w;
                        break;
                    }
                    case 303: 
                    case 306: {
                        lab = "Eckenzahl =";
                        mitParameter = true;
                        mitAnzeige = true;
                        txt = String.valueOf(Geopro.vieleck[Vieleck.nummer].eck);
                    }
                }
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.vieleck[Vieleck.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.vieleck[Vieleck.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.vieleck[Vieleck.nummer].dicke;
                Geopro.aktStrich = Geopro.vieleck[Vieleck.nummer].strich;
                Geopro.aktVoll = Geopro.vieleck[Vieleck.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.vieleck[Vieleck.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void ebeneAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.ebene[Ebene.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].ebenenZahl) {
                        Geopro.ebene[i].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                        Geopro.ebene[i].dicke = Geopro.aktDicke;
                        Geopro.ebene[i].strich = Geopro.aktStrich;
                        Geopro.ebene[i].voll = Geopro.aktVoll;
                        if (this.layerAnders) {
                            int j = 0;
                            while (j < 5) {
                                Geopro.ebene[i].layer[j] = Geopro.aktLayer[j];
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    Geopro.ebene[Ebene.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                    Geopro.ebene[Ebene.nummer].dicke = Geopro.aktDicke;
                    Geopro.ebene[Ebene.nummer].strich = Geopro.aktStrich;
                    Geopro.ebene[Ebene.nummer].voll = Geopro.aktVoll;
                    if (!this.layerAnders) break;
                    int j = 0;
                    while (j < 5) {
                        Geopro.ebene[Ebene.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].ebenenZahl) {
                        Geopro.ebene[i].farbe = 0;
                        Geopro.ebene[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.ebene[Ebene.nummer].farbe = 0;
                Geopro.ebene[Ebene.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.ebene[Ebene.nummer].farbe = f = this.umDef(Geopro.ebene[Ebene.nummer].farbe);
                if (f >= 0) {
                    Geopro.ebene[Ebene.nummer].def = true;
                    break;
                }
                Geopro.ebene[Ebene.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].ebenenZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.ebene[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.ebene[Ebene.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Ebene.markiert = Ebene.nummer;
                this.name = Geopro.ebene[Ebene.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.ebene[Ebene.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.ebene[Ebene.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.ebene[Ebene.nummer].dicke;
                Geopro.aktStrich = Geopro.ebene[Ebene.nummer].strich;
                Geopro.aktVoll = Geopro.ebene[Ebene.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.ebene[Ebene.nummer].layer[j];
                    ++j;
                }
                Attribute.def.setSelected(Geopro.ebene[Ebene.nummer].def);
                String lab = "";
                String txt = "";
                if (Geopro.ebene[Ebene.nummer].typ == 419) {
                    Geopro.analytModus = true;
                    Geopro.objektLeiste.analytisch(4, Ebene.nummer);
                } else if (Geopro.ebene[Ebene.nummer].typ == 429) {
                    Geopro.analytModus = true;
                    Geopro.objektLeiste.analytisch(5, Ebene.nummer);
                } else if (Geopro.ebene[Ebene.nummer].typ == 420) {
                    lab = "Radius = ";
                    mitParameter = true;
                    mitAnzeige = true;
                    txt = String.valueOf(Skalar.runde(Geopro.ebene[Ebene.nummer].radius, this.stellen));
                }
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.ebene[Ebene.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.ebene[Ebene.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.ebene[Ebene.nummer].dicke;
                Geopro.aktStrich = Geopro.ebene[Ebene.nummer].strich;
                Geopro.aktVoll = Geopro.ebene[Ebene.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.ebene[Ebene.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void koerperAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.koerper[Koerper.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].koerperZahl) {
                        Geopro.koerper[i].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                        Geopro.koerper[i].dicke = Geopro.aktDicke;
                        Geopro.koerper[i].strich = Geopro.aktStrich;
                        Geopro.koerper[i].voll = Geopro.aktVoll;
                        if (this.layerAnders) {
                            int j = 0;
                            while (j < 5) {
                                Geopro.koerper[i].layer[j] = Geopro.aktLayer[j];
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    Geopro.koerper[Koerper.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                    Geopro.koerper[Koerper.nummer].dicke = Geopro.aktDicke;
                    Geopro.koerper[Koerper.nummer].strich = Geopro.aktStrich;
                    Geopro.koerper[Koerper.nummer].voll = Geopro.aktVoll;
                    if (!this.layerAnders) break;
                    int j = 0;
                    while (j < 5) {
                        Geopro.koerper[Koerper.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].koerperZahl) {
                        Geopro.koerper[i].farbe = 0;
                        Geopro.koerper[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.koerper[Koerper.nummer].farbe = 0;
                Geopro.koerper[Koerper.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.koerper[Koerper.nummer].farbe = f = this.umDef(Geopro.koerper[Koerper.nummer].farbe);
                if (f >= 0) {
                    Geopro.koerper[Koerper.nummer].def = true;
                    break;
                }
                Geopro.koerper[Koerper.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].koerperZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.koerper[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.koerper[Koerper.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Koerper.markiert = Koerper.nummer;
                this.name = Geopro.koerper[Koerper.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.koerper[Koerper.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.koerper[Koerper.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.koerper[Koerper.nummer].dicke;
                Geopro.aktStrich = Geopro.koerper[Koerper.nummer].strich;
                Geopro.aktVoll = Geopro.koerper[Koerper.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.koerper[Koerper.nummer].layer[j];
                    ++j;
                }
                Attribute.def.setSelected(Geopro.koerper[Koerper.nummer].def);
                String lab = "";
                String txt = "";
                switch (Geopro.koerper[Koerper.nummer].typ) {
                    case 500: {
                        lab = "Seite =";
                        mitParameter = true;
                        mitAnzeige = true;
                        txt = Geopro.koerper[Koerper.nummer].seite;
                        break;
                    }
                    case 501: {
                        lab = "Seiten = ";
                        mitParameter = true;
                        mitAnzeige = true;
                        txt = String.valueOf(Geopro.koerper[Koerper.nummer].xSeite) + "," + Geopro.koerper[Koerper.nummer].ySeite + "," + Geopro.koerper[Koerper.nummer].zSeite;
                        break;
                    }
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 512: {
                        lab = "Halbmesser = ";
                        mitParameter = true;
                        mitAnzeige = true;
                        txt = Geopro.koerper[Koerper.nummer].halb;
                    }
                }
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.koerper[Koerper.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.koerper[Koerper.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.koerper[Koerper.nummer].dicke;
                Geopro.aktStrich = Geopro.koerper[Koerper.nummer].strich;
                Geopro.aktVoll = Geopro.koerper[Koerper.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.koerper[Koerper.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void massAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                String altName = Geopro.mass[Messen.nummer].name;
                if (altName.length() == 1) {
                    char n = altName.charAt(0);
                    int i = 0;
                    while (i < Geopro.varzahl) {
                        if (n == Geopro.varterm.charAt(i)) {
                            Geopro.zahlterm[i] = new Zahlterm(-1, "");
                        }
                        ++i;
                    }
                }
                Geopro.mass[Messen.nummer].name = Protokoll.eingabe();
                Geopro.mass[Messen.nummer].neueWerte();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].messZahl) {
                        Geopro.mass[i].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                        Geopro.mass[i].voll = Geopro.aktVoll;
                        if (this.layerAnders) {
                            int j = 0;
                            while (j < 5) {
                                Geopro.mass[i].layer[j] = Geopro.aktLayer[j];
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    Geopro.mass[Messen.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                    Geopro.mass[Messen.nummer].voll = Geopro.aktVoll;
                    if (!this.layerAnders) break;
                    int j = 0;
                    while (j < 5) {
                        Geopro.mass[Messen.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].messZahl) {
                        Geopro.mass[i].farbe = 0;
                        Geopro.mass[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.mass[Messen.nummer].farbe = 0;
                Geopro.mass[Messen.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.mass[Messen.nummer].farbe = f = this.umDef(Geopro.mass[Messen.nummer].farbe);
                if (f >= 0) {
                    Geopro.mass[Messen.nummer].def = true;
                    break;
                }
                Geopro.mass[Messen.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].messZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.mass[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.mass[Messen.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Objektleiste.variableZeigen(true);
                Attribute.markierungenEntfernen();
                Messen.markiert = Messen.nummer;
                String altName = Geopro.mass[Messen.nummer].name;
                if (altName.length() == 1) {
                    char n = altName.charAt(0);
                    int i = 0;
                    while (i < Geopro.varzahl) {
                        if (n == Geopro.varterm.charAt(i)) {
                            Geopro.zahlterm[i] = new Zahlterm(-1, "");
                        }
                        ++i;
                    }
                }
                this.name = Geopro.mass[Messen.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Geopro.mass[Messen.nummer].neueWerte();
                Attribute.nameEingabe.setText(this.name);
                Attribute.def.setSelected(Geopro.mass[Messen.nummer].def);
                int f = Math.abs(Geopro.mass[Messen.nummer].farbe % 100);
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.mass[Messen.nummer].farbe) / 100;
                Geopro.aktVoll = Geopro.mass[Messen.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.mass[Messen.nummer].layer[j];
                    ++j;
                }
                String lab = "";
                String txt = "";
                Attribute.rand.setSelected(Geopro.mass[Messen.nummer].schrift / 10 == 1);
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, true);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.mass[Messen.nummer].farbe % 100);
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.mass[Messen.nummer].farbe) / 100;
                Geopro.aktVoll = Geopro.mass[Messen.nummer].voll;
                Attribute.rand.setSelected(Geopro.mass[Messen.nummer].schrift / 10 == 1);
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.mass[Messen.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void abbildAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.abbild[Abbild.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                Geopro.abbild[Abbild.nummer].farbe = Geopro.aktRand;
                if (!this.layerAnders) break;
                int j = 0;
                while (j < 5) {
                    Geopro.abbild[Abbild.nummer].layer[j] = Geopro.aktLayer[j];
                    ++j;
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].abbildZahl) {
                        Geopro.abbild[i].farbe = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.abbild[Abbild.nummer].farbe = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.abbild[Abbild.nummer].farbe = f = this.umDef(Geopro.abbild[Abbild.nummer].farbe);
                if (f >= 0) {
                    Geopro.abbild[Abbild.nummer].def = true;
                    break;
                }
                Geopro.abbild[Abbild.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].abbildZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.abbild[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.abbild[Abbild.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Abbild.markiert = Abbild.nummer;
                this.name = Geopro.abbild[Abbild.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.abbild[Abbild.nummer].farbe % 100);
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = 0;
                Geopro.aktVoll = 0;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.abbild[Abbild.nummer].layer[j];
                    ++j;
                }
                Attribute.def.setSelected(Geopro.abbild[Abbild.nummer].def);
                String lab = "";
                String txt = "";
                if (Geopro.abbild[Abbild.nummer].typ == 705) {
                    lab = "Faktor = ";
                    mitParameter = true;
                    mitAnzeige = true;
                    txt = String.valueOf(Geopro.abbild[Abbild.nummer].streckTerm);
                    Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                    break;
                }
                if (Geopro.abbild[Abbild.nummer].typ == 701) {
                    lab = "Winkel = ";
                    mitParameter = true;
                    mitAnzeige = true;
                    txt = String.valueOf(Geopro.abbild[Abbild.nummer].winkTerm);
                    Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                    break;
                }
                if (Geopro.abbild[Abbild.nummer].typ == 719) {
                    int i = 1;
                    while (i <= 3) {
                        int j2 = 1;
                        while (j2 <= 2) {
                            Attribute.mat[i][j2].setText("");
                            ++j2;
                        }
                        ++i;
                    }
                    Attribute.mat[1][1].setText(Skalar.runde(Geopro.abbild[Abbild.nummer].matr.u.x, Geopro.stellen));
                    Attribute.mat[1][2].setText(Skalar.runde(Geopro.abbild[Abbild.nummer].matr.u.y, Geopro.stellen));
                    Attribute.mat[2][1].setText(Skalar.runde(Geopro.abbild[Abbild.nummer].matr.v.x, Geopro.stellen));
                    Attribute.mat[2][2].setText(Skalar.runde(Geopro.abbild[Abbild.nummer].matr.v.y, Geopro.stellen));
                    Attribute.mat[3][1].setText(Skalar.runde(Geopro.abbild[Abbild.nummer].vekt.x, Geopro.stellen));
                    Attribute.mat[3][2].setText(Skalar.runde(Geopro.abbild[Abbild.nummer].vekt.y, Geopro.stellen));
                    Geopro.operationsLeiste.para("Matrix, Vektor:", "", true, false, 0);
                    break;
                }
                if (Geopro.abbild[Abbild.nummer].typ == 720) {
                    Geopro.operationsLeiste.para("w(z) =", Geopro.abbild[Abbild.nummer].wTerm, true, true, false);
                    break;
                }
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.abbild[Abbild.nummer].farbe % 100);
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = 0;
                Geopro.aktVoll = 0;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.abbild[Abbild.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void markeAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitRadius = false;
        boolean mitGroesse = false;
        boolean mitMathtext = false;
        boolean mitRand = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.marke[Marke.nummer].text = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].markenZahl) {
                        Geopro.marke[i].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                        Geopro.marke[i].dicke = Geopro.aktDicke;
                        Geopro.marke[i].voll = Geopro.aktVoll;
                        Geopro.marke[i].art = Geopro.aktWinkel;
                        if (this.layerAnders) {
                            int j = 0;
                            while (j < 5) {
                                Geopro.marke[i].layer[j] = Geopro.aktLayer[j];
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    Geopro.marke[Marke.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                    Geopro.marke[Marke.nummer].dicke = Geopro.aktDicke;
                    Geopro.marke[Marke.nummer].voll = Geopro.aktVoll;
                    Geopro.marke[Marke.nummer].art = Geopro.aktWinkel;
                    if (!this.layerAnders) break;
                    int j = 0;
                    while (j < 5) {
                        Geopro.marke[Marke.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].markenZahl) {
                        Geopro.marke[i].farbe = 0;
                        Geopro.marke[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.marke[Marke.nummer].farbe = 0;
                Geopro.marke[Marke.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.marke[Marke.nummer].farbe = f = this.umDef(Geopro.marke[Marke.nummer].farbe);
                if (f >= 0) {
                    Geopro.marke[Marke.nummer].def = true;
                    break;
                }
                Geopro.marke[Marke.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].markenZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.marke[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.marke[Marke.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Marke.markiert = Marke.nummer;
                this.name = Geopro.marke[Marke.nummer].text;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.marke[Marke.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.marke[Marke.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.marke[Marke.nummer].dicke;
                Geopro.aktVoll = Geopro.marke[Marke.nummer].voll;
                Geopro.aktWinkel = Geopro.marke[Marke.nummer].art;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.marke[Marke.nummer].layer[j];
                    ++j;
                }
                Attribute.def.setSelected(Geopro.marke[Marke.nummer].def);
                String lab = "";
                String txt = "";
                if (Geopro.marke[Marke.nummer].typ == 806) {
                    lab = "Radius = ";
                    mitParameter = true;
                    mitRadius = true;
                    txt = String.valueOf(Skalar.runde(Geopro.marke[Marke.nummer].rad, this.stellen));
                    break;
                }
                if (Geopro.marke[Marke.nummer].typ > 803 && Geopro.marke[Marke.nummer].typ != 807 && Geopro.marke[Marke.nummer].typ != 808) break;
                lab = "Schriftgr\u00f6sse:";
                mitParameter = false;
                mitMathtext = true;
                mitRand = true;
                mitGroesse = true;
                Attribute.nameLabel.setText("Text:");
                int schrift = Geopro.marke[Marke.nummer].schrift;
                int gross = schrift / 100;
                Attribute.math.setSelected((schrift - 100 * gross) % 10 == 1);
                Attribute.rand.setSelected((schrift - 100 * gross) / 10 == 1);
                if (Geopro.marke[Marke.nummer].typ == 808) {
                    Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitRadius, mitGroesse, false, false, mitMathtext, mitRand);
                    break;
                }
                Geopro.operationsLeiste.para("", txt, true, mitParameter, mitRadius, false, false, false, mitMathtext, mitRand);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.marke[Marke.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.marke[Marke.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.marke[Marke.nummer].dicke;
                Geopro.aktVoll = Geopro.marke[Marke.nummer].voll;
                Geopro.aktWinkel = Geopro.marke[Marke.nummer].art;
                int schrift = Geopro.marke[Marke.nummer].schrift;
                int gross = schrift / 100;
                Attribute.math.setSelected((schrift - 100 * gross) % 10 == 1);
                Attribute.rand.setSelected((schrift - 100 * gross) / 10 == 1);
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.marke[Marke.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitRadius);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void ortslinieAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitParameter = false;
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.ortslinie[Ortslinie.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                Geopro.ortslinie[Ortslinie.nummer].fein = Geopro.aktFein;
                Geopro.ortslinie[Ortslinie.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                Geopro.ortslinie[Ortslinie.nummer].dicke = Geopro.aktDicke;
                Geopro.ortslinie[Ortslinie.nummer].strich = Geopro.aktStrich;
                Geopro.ortslinie[Ortslinie.nummer].voll = Geopro.aktVoll;
                if (!this.layerAnders) break;
                int j = 0;
                while (j < 5) {
                    Geopro.ortslinie[Ortslinie.nummer].layer[j] = Geopro.aktLayer[j];
                    ++j;
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].ortslinienZahl) {
                        Geopro.ortslinie[i].farbe = 0;
                        Geopro.ortslinie[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.ortslinie[Ortslinie.nummer].farbe = 0;
                Geopro.ortslinie[Ortslinie.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.ortslinie[Ortslinie.nummer].farbe = f = this.umDef(Geopro.ortslinie[Ortslinie.nummer].farbe);
                if (f >= 0) {
                    Geopro.ortslinie[Ortslinie.nummer].def = true;
                    break;
                }
                Geopro.ortslinie[Ortslinie.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].ortslinienZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.ortslinie[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.ortslinie[Ortslinie.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Ortslinie.markiert = Ortslinie.nummer;
                this.name = Geopro.ortslinie[Ortslinie.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.ortslinie[Ortslinie.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.ortslinie[Ortslinie.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.ortslinie[Ortslinie.nummer].dicke;
                Geopro.aktStrich = Geopro.ortslinie[Ortslinie.nummer].strich;
                Geopro.aktVoll = Geopro.ortslinie[Ortslinie.nummer].voll;
                Geopro.aktFein = Geopro.ortslinie[Ortslinie.nummer].fein;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.ortslinie[Ortslinie.nummer].layer[j];
                    ++j;
                }
                if (Geopro.ortslinie[Ortslinie.nummer].typ > 900 && Geopro.ortslinie[Ortslinie.nummer].typ < 904) {
                    Geopro.aktFlaeche = 0;
                    Geopro.aktVoll = 0;
                }
                Attribute.def.setSelected(Geopro.ortslinie[Ortslinie.nummer].def);
                int typ = Geopro.ortslinie[Ortslinie.nummer].typ;
                String lab = "";
                String txt = "";
                if (typ == 901) {
                    lab = "";
                    mitParameter = false;
                    txt = String.valueOf(Geopro.ortslinie[Ortslinie.nummer].anzahl);
                } else if (typ == 900) {
                    lab = "y(x) ; x\u2081,x\u2082";
                    mitParameter = true;
                    String ys = Geopro.ortslinie[Ortslinie.nummer].fTerm;
                    String as = Geopro.ortslinie[Ortslinie.nummer].von;
                    String bs = Geopro.ortslinie[Ortslinie.nummer].bis;
                    txt = String.valueOf(ys) + " ; " + as + "," + bs;
                } else if (typ == 902 || typ == 903) {
                    if (Geopro.dimension == 2) {
                        lab = "x(t),y(t) ; t\u2081,t\u2082";
                        mitParameter = true;
                        String xs = Geopro.ortslinie[Ortslinie.nummer].xTerm;
                        String ys = Geopro.ortslinie[Ortslinie.nummer].yTerm;
                        String as = Geopro.ortslinie[Ortslinie.nummer].von;
                        String bs = Geopro.ortslinie[Ortslinie.nummer].bis;
                        txt = String.valueOf(xs) + "," + ys + " ; " + as + "," + bs;
                    } else {
                        lab = "x(t),y(t),z(t) ; t\u2081,t\u2082";
                        mitParameter = true;
                        String xs = Geopro.ortslinie[Ortslinie.nummer].xTerm;
                        String ys = Geopro.ortslinie[Ortslinie.nummer].yTerm;
                        String zs = Geopro.ortslinie[Ortslinie.nummer].zTerm;
                        String as = Geopro.ortslinie[Ortslinie.nummer].von;
                        String bs = Geopro.ortslinie[Ortslinie.nummer].bis;
                        txt = String.valueOf(xs) + "," + ys + "," + zs + " ; " + as + "," + bs;
                    }
                } else if (typ == 904 || typ == 905 || typ == 912) {
                    mitAnzeige = false;
                }
                Geopro.operationsLeiste.para(lab, txt, true, mitParameter, mitAnzeige, false, false, false, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.ortslinie[Ortslinie.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.ortslinie[Ortslinie.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.ortslinie[Ortslinie.nummer].dicke;
                Geopro.aktStrich = Geopro.ortslinie[Ortslinie.nummer].strich;
                Geopro.aktVoll = Geopro.ortslinie[Ortslinie.nummer].voll;
                Geopro.aktFein = Geopro.ortslinie[Ortslinie.nummer].fein;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.ortslinie[Ortslinie.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void gebietAnders(boolean alle) {
        Objektleiste.variableZeigen(false);
        boolean mitAnzeige = false;
        switch (Geopro.objektModus) {
            case 1: {
                Geopro.gebiet[Gebiet.nummer].name = Protokoll.eingabe();
                Bildtafel.eingabeLeeren();
                break;
            }
            case 2: {
                Geopro.gebiet[Gebiet.nummer].farbe = 100 * Geopro.aktFlaeche + Geopro.aktRand;
                Geopro.gebiet[Gebiet.nummer].dicke = Geopro.aktDicke;
                Geopro.gebiet[Gebiet.nummer].strich = Geopro.aktStrich;
                Geopro.gebiet[Gebiet.nummer].voll = Geopro.aktVoll;
                if (!this.layerAnders) break;
                int j = 0;
                while (j < 5) {
                    Geopro.gebiet[Gebiet.nummer].layer[j] = Geopro.aktLayer[j];
                    ++j;
                }
                break;
            }
            case 3: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].gebietZahl) {
                        Geopro.gebiet[i].farbe = 0;
                        Geopro.gebiet[i].voll = 0;
                        ++i;
                    }
                    break;
                }
                Geopro.gebiet[Gebiet.nummer].farbe = 0;
                Geopro.gebiet[Gebiet.nummer].voll = 0;
                break;
            }
            case 4: {
                int f;
                Geopro.gebiet[Gebiet.nummer].farbe = f = this.umDef(Geopro.gebiet[Gebiet.nummer].farbe);
                if (f >= 0) {
                    Geopro.gebiet[Gebiet.nummer].def = true;
                    break;
                }
                Geopro.gebiet[Gebiet.nummer].def = false;
                break;
            }
            case 5: {
                if (alle) {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].gebietZahl) {
                        int j = 0;
                        while (j < 5) {
                            Geopro.gebiet[i].layer[j] = Geopro.aktLayer[j];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < 5) {
                        Geopro.gebiet[Gebiet.nummer].layer[j] = Geopro.aktLayer[j];
                        ++j;
                    }
                }
                break;
            }
            case 6: {
                Attribute.markierungenEntfernen();
                Gebiet.markiert = Gebiet.nummer;
                this.name = Geopro.gebiet[Gebiet.nummer].name;
                if (this.name.equals("_")) {
                    this.name = "";
                }
                Attribute.nameEingabe.setText(this.name);
                int f = Math.abs(Geopro.gebiet[Gebiet.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.gebiet[Gebiet.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.gebiet[Gebiet.nummer].dicke;
                Geopro.aktStrich = Geopro.gebiet[Gebiet.nummer].strich;
                Geopro.aktVoll = Geopro.gebiet[Gebiet.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.gebiet[Gebiet.nummer].layer[j];
                    ++j;
                }
                Attribute.def.setSelected(Geopro.gebiet[Gebiet.nummer].def);
                String lab = "Operation:";
                Geopro.operationsLeiste.para(lab, "", true, false, false, false, true, false, false, false);
                break;
            }
            case 7: {
                int f = Math.abs(Geopro.gebiet[Gebiet.nummer].farbe) % 100;
                Geopro.aktRand = f == 0 || f == -20 ? 0 : Math.abs(f);
                Geopro.aktFlaeche = Math.abs(Geopro.gebiet[Gebiet.nummer].farbe) / 100;
                Geopro.aktDicke = Geopro.gebiet[Gebiet.nummer].dicke;
                Geopro.aktStrich = Geopro.gebiet[Gebiet.nummer].strich;
                Geopro.aktVoll = Geopro.gebiet[Gebiet.nummer].voll;
                int j = 0;
                while (j < 5) {
                    Geopro.aktLayer[j] = Geopro.gebiet[Gebiet.nummer].layer[j];
                    ++j;
                }
                break;
            }
        }
        Attribute.zeig.setSelected(mitAnzeige);
        Geopro.konstruktion[Konstruktion.nummer].auffrischen();
        Attribute.attributgraphik.repaint();
    }

    void klicken(int nr, boolean shift, boolean alt, boolean rechteMaus) {
        boolean neu = true;
        Geopro.operationsLeiste.anfang = true;
        if (rechteMaus) {
            Geopro.objektModus = 6;
        }
        if (Punkt.nummer >= 0) {
            if (Punkt.fangzahl > 0) {
                neu = Punkt.neuerPunkt(Punkt.nummer);
                if (neu) {
                    Punkt.fangliste[Punkt.fangzahl] = Punkt.nummer;
                    Geopro.punkt[Punkt.nummer].gefangen = true;
                    --Punkt.fangzahl;
                } else {
                    Geopro.beep();
                }
            } else if (Geopro.objektModus > 0) {
                this.punktAnders(alt);
            } else if (shift) {
                Geopro.plantafel.suchen(1, Punkt.nummer);
                Geopro.plantafel.aktuell();
            }
        } else if (Gerade.nummer >= 0) {
            if (Gerade.fangzahl > 0) {
                neu = Gerade.neueGerade(Gerade.nummer);
                if (neu) {
                    Gerade.fangliste[Gerade.fangzahl] = Gerade.nummer;
                    Geopro.gerade[Gerade.nummer].gefangen = true;
                    --Gerade.fangzahl;
                } else {
                    Geopro.beep();
                }
            } else if (Geopro.objektModus > 0) {
                this.geradeAnders(alt);
            } else if (shift) {
                Geopro.plantafel.suchen(2, Gerade.nummer);
                Geopro.plantafel.aktuell();
            }
        } else if (Vieleck.nummer >= 0) {
            if (Vieleck.fangzahl > 0) {
                neu = Vieleck.neuesVieleck(Vieleck.nummer);
                if (neu) {
                    Vieleck.fangliste[Vieleck.fangzahl] = Vieleck.nummer;
                    Geopro.vieleck[Vieleck.nummer].gefangen = true;
                    --Vieleck.fangzahl;
                } else {
                    Geopro.beep();
                }
            } else if (Geopro.objektModus > 0) {
                this.vieleckAnders(alt);
            } else if (shift) {
                Geopro.plantafel.suchen(3, Vieleck.nummer);
                Geopro.plantafel.aktuell();
            }
        } else if (Ebene.nummer >= 0) {
            if (Ebene.fangzahl > 0) {
                neu = Ebene.neueEbene(Ebene.nummer);
                if (neu) {
                    Ebene.fangliste[Ebene.fangzahl] = Ebene.nummer;
                    Geopro.ebene[Ebene.nummer].gefangen = true;
                    --Ebene.fangzahl;
                } else {
                    Geopro.beep();
                }
            } else if (Geopro.objektModus > 0) {
                this.ebeneAnders(alt);
            }
        } else if (Koerper.nummer >= 0) {
            if (Koerper.fangzahl > 0) {
                neu = Koerper.neuerKoerper(Koerper.nummer);
                if (neu) {
                    Koerper.fangliste[Koerper.fangzahl] = Koerper.nummer;
                    Geopro.koerper[Koerper.nummer].gefangen = true;
                    --Koerper.fangzahl;
                } else {
                    Geopro.beep();
                }
            } else if (Geopro.objektModus > 0) {
                this.koerperAnders(alt);
            }
        } else if (Messen.nummer >= 0) {
            if (Messen.fangzahl > 0) {
                Messen.fangliste[Messen.fangzahl] = Messen.nummer;
                --Messen.fangzahl;
            } else if (Geopro.objektModus > 0) {
                this.massAnders(alt);
            }
        } else if (Abbild.nummer >= 0) {
            if (Abbild.fangzahl > 0) {
                neu = Abbild.neuesAbbild(Abbild.nummer);
                if (neu) {
                    Abbild.fangliste[Abbild.fangzahl] = Abbild.nummer;
                    Geopro.abbild[Abbild.nummer].gefangen = true;
                    --Abbild.fangzahl;
                } else {
                    Geopro.beep();
                }
            } else if (Geopro.objektModus > 0) {
                this.abbildAnders(alt);
            }
        } else if (Marke.nummer >= 0) {
            if (Marke.fangzahl > 0) {
                Marke.fangliste[Marke.fangzahl] = Marke.nummer;
                Geopro.marke[Marke.nummer].gefangen = true;
                --Marke.fangzahl;
            } else if (Geopro.objektModus > 0) {
                this.markeAnders(alt);
            }
        } else if (Ortslinie.nummer >= 0) {
            if (Ortslinie.fangzahl > 0) {
                Ortslinie.fangliste[Ortslinie.fangzahl] = Ortslinie.nummer;
                --Ortslinie.fangzahl;
            } else if (Geopro.objektModus > 0) {
                this.ortslinieAnders(alt);
            }
        } else if (Gebiet.nummer >= 0) {
            if (Gebiet.fangzahl > 0) {
                Gebiet.fangliste[Ortslinie.fangzahl] = Gebiet.nummer;
                --Gebiet.fangzahl;
            } else if (Geopro.objektModus > 0) {
                this.gebietAnders(alt);
            }
        }
        this.ausfuehren(shift, alt);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.zeile = -1;
        this.neuFangen();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int Y = e.getY();
        this.neuFangen();
        int s = Geopro.konstruktion[Konstruktion.nummer].stand;
        this.zeile = Y / h;
        if (this.zeile >= s) {
            this.zeile = -1;
            Infoleiste.infoZeile = "";
        } else {
            this.fangen(this.zeile);
        }
        Geopro.infoLeiste.repaint();
        Geopro.neuZeichnen();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int Y = e.getY();
        boolean shift = e.isShiftDown();
        boolean alt = e.isAltDown();
        boolean rechteMaus = e.isControlDown() || e.isMetaDown() || e.getModifiersEx() == 4096;
        int s = Geopro.konstruktion[Konstruktion.nummer].stand;
        this.zeile = Y / h;
        if (this.zeile >= s) {
            this.zeile = -1;
        } else {
            if (Geopro.operationsLeiste.anfang) {
                Bildtafel.alteKonstruktion();
            }
            if (rechteMaus) {
                Geopro.objektModus = 6;
            }
            this.klicken(this.zeile, shift, alt, rechteMaus);
            this.neuFangen();
            if (this.zeile >= 0) {
                this.fangen(this.zeile);
            }
        }
        Geopro.objektWuensche = Geopro.operationsLeiste.objektWunsch();
    }
}

