/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class DruckerFenster
extends Dialoge {
    private static final long serialVersionUID = 1L;
    JLabel txt1;
    JLabel txt2;
    JLabel txt3;
    JButton ok;
    JButton normal;
    JButton abbrechen;
    JButton dialog;
    JButton drucken;
    JTextField skalierung;
    JTextField unterschrift;
    JRadioButton vertikal;
    JRadioButton horizontal;
    JCheckBox box;
    JCheckBox blei;
    JCheckBox mit;
    Vorschaugraphik graphikVorschau = new Vorschaugraphik();
    boolean mitGraphik = true;
    int dim = Geopro.dimension;

    DruckerFenster(JFrame f, String t, boolean m) {
        super(f, t, m);
        this.setLocation(400, 130);
        this.setSize(400, 530);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JPanel pan1 = new JPanel();
        pan1.setLayout(null);
        pan1.setPreferredSize(new Dimension(0, 130));
        this.txt1 = new JLabel("Orientierung:");
        this.txt1.setBounds(20, 20, 100, 20);
        this.txt2 = new JLabel("Skalierung:");
        this.txt2.setBounds(20, 50, 100, 20);
        this.txt3 = new JLabel("%");
        this.txt3.setBounds(201, 50, 20, 20);
        pan1.add(this.txt1);
        pan1.add(this.txt2);
        pan1.add(this.txt3);
        this.vertikal = new JRadioButton("Hochformat", Geopro.hochformat);
        this.vertikal.setBounds(140, 20, 120, 20);
        this.vertikal.addActionListener(this);
        this.vertikal.setFocusable(false);
        this.horizontal = new JRadioButton("Querformat", !Geopro.hochformat);
        this.horizontal.setBounds(270, 20, 120, 20);
        this.horizontal.addActionListener(this);
        this.horizontal.setFocusable(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.vertikal);
        bg.add(this.horizontal);
        pan1.add(this.vertikal);
        pan1.add(this.horizontal);
        this.skalierung = new JTextField();
        this.skalierung.setToolTipText("Eingabe mit [Return]-Taste!");
        this.skalierung.setText(String.valueOf(Geopro.skalierung));
        this.skalierung.setBounds(146, 50, 53, 20);
        this.skalierung.addActionListener(this);
        pan1.add(this.skalierung);
        this.normal = new JButton("Originalgr\u00f6sse");
        this.normal.setToolTipText("Die Skalierung wird auf 100% gesetzt.");
        this.normal.setBounds(225, 49, 155, 24);
        this.normal.addActionListener(this);
        this.normal.setFocusable(false);
        pan1.add(this.normal);
        String txt = "mit Vorschaugraphik";
        if (this.dim == 1) {
            txt = "mit Vorschautext";
        }
        this.box = new JCheckBox(txt, this.mitGraphik);
        this.box.setToolTipText("mit oder ohne Vorschau");
        this.box.setBounds(45, 80, 170, 20);
        this.box.addActionListener(this);
        this.box.setFocusable(false);
        pan1.add(this.box);
        this.blei = new JCheckBox("mit Bleistiftlinien", Geopro.mitBleistift);
        this.blei.setToolTipText("mit oder ohne 'Bleistiftlinien'");
        this.blei.setBounds(225, 80, 200, 20);
        this.blei.addActionListener(this);
        this.blei.setFocusable(false);
        this.blei.setVisible(this.dim != 1);
        pan1.add(this.blei);
        this.mit = new JCheckBox("", Geopro.mitUnterschrift);
        this.mit.setToolTipText("mit oder ohne 'Unterschrift' (keine Kommas und Strichpunkte erlaubt!)");
        this.mit.setBounds(45, 105, 25, 20);
        this.mit.addActionListener(this);
        this.mit.setFocusable(false);
        this.mit.setVisible(this.dim != 1);
        pan1.add(this.mit);
        this.unterschrift = new JTextField(Geopro.unterschrift);
        this.unterschrift.setBounds(70, 105, 255, 20);
        this.unterschrift.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 2, 10));
        this.unterschrift.addActionListener(this);
        this.unterschrift.setVisible(this.dim != 1);
        pan1.add(this.unterschrift);
        this.ok = new JButton("OK");
        this.ok.setToolTipText("Neue Unterschrift wird definiert.");
        this.ok.setBounds(330, 104, 50, 24);
        this.ok.addActionListener(this);
        this.ok.setFocusable(false);
        this.ok.setVisible(this.dim != 1);
        pan1.add(this.ok);
        JPanel pan3 = new JPanel(null);
        pan3.setPreferredSize(new Dimension(0, 55));
        this.abbrechen = new JButton("Abbrechen");
        this.abbrechen.setToolTipText("Alle aktuellen Eingaben werden \u00fcbernommen.");
        this.abbrechen.setBounds(20, 15, 100, 24);
        this.abbrechen.addActionListener(this);
        pan3.add(this.abbrechen);
        this.dialog = new JButton("Druckerdialog...");
        this.dialog.setToolTipText("Der Druckerdialog wird angezeigt.");
        this.dialog.setBounds(125, 15, 150, 24);
        this.dialog.addActionListener(this);
        pan3.add(this.dialog);
        this.drucken = new JButton("Drucken");
        this.drucken.setToolTipText("Die Zeichnung wird direkt gedruckt.");
        this.drucken.setBounds(280, 15, 100, 24);
        this.drucken.addActionListener(this);
        pan3.add(this.drucken);
        this.add("North", pan1);
        this.add("Center", this.graphikVorschau);
        this.add("South", pan3);
    }

    void skalierung(boolean direkt) {
        String txt = this.skalierung.getText();
        double s = 100.0;
        try {
            s = Skalar.zahl(txt);
            if (s < 0.0) {
                s = Math.abs(s);
            }
            if (s > 1.0 && s < 1000.0) {
                Geopro.skalierung = Skalar.runde(s);
                if (direkt) {
                    Ablage.geoDrucken();
                }
            } else {
                Geopro.skalierung = 100;
                this.skalierung.setText("100");
                this.skalierung.selectAll();
            }
        }
        catch (Exception ex) {
            Geopro.skalierung = 100;
            this.skalierung.setText("100");
            this.skalierung.selectAll();
        }
    }

    void druck(boolean direkt) {
        Geopro.hochformat = this.vertikal.isSelected();
        this.skalierung(direkt);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object m = e.getSource();
        if (m == this.vertikal || m == this.horizontal) {
            Geopro.hochformat = this.vertikal.isSelected();
            this.skalierung(false);
            this.graphikVorschau.repaint();
            Geopro.unsauber();
        } else if (m == this.skalierung) {
            this.skalierung(false);
            this.graphikVorschau.repaint();
        } else if (m == this.normal) {
            this.skalierung.setText("100");
            this.skalierung(false);
            this.skalierung.selectAll();
            this.graphikVorschau.repaint();
        } else if (m == this.box) {
            this.mitGraphik = this.box.isSelected();
            this.graphikVorschau.repaint();
        } else if (m == this.blei) {
            Geopro.mitBleistift = this.blei.isSelected();
            this.graphikVorschau.repaint();
            Geopro.neuZeichnen();
            Geopro.infoLeiste.repaint();
        } else if (m == this.mit) {
            Geopro.mitUnterschrift = this.mit.isSelected();
            String txt = this.unterschrift.getText();
            txt = txt.replaceAll(",", " ");
            Geopro.unterschrift = txt = txt.replaceAll(";", " ");
            this.graphikVorschau.repaint();
            Geopro.neuGraphik();
        } else if (m == this.ok || m == this.unterschrift) {
            String txt = this.unterschrift.getText();
            txt = txt.replaceAll(",", " ");
            Geopro.unterschrift = txt = txt.replaceAll(";", " ");
            this.graphikVorschau.repaint();
            Geopro.neuGraphik();
        } else if (m == this.abbrechen) {
            this.druck(false);
            this.dispose();
        } else if (m == this.dialog) {
            this.skalierung(false);
            this.dispose();
            if (this.dim == 1) {
                Ablage.casDruckerOeffnen();
            } else {
                Ablage.geoDruckerOeffnen();
            }
        } else if (m == this.drucken) {
            this.druck(true);
            this.dispose();
        }
    }

    class Vorschaugraphik
    extends JPanel {
        private static final long serialVersionUID = 1L;
        int L = 50;
        int O = 10;
        int B = 210;
        int H = 297;
        int R = 20;
        int s = 2;

        Vorschaugraphik() {
        }

        @Override
        public void paint(Graphics gg) {
            Graphics2D g = (Graphics2D)gg;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.gray);
            if (Geopro.hochformat) {
                g.fillRect(this.L + 2, this.O + 2, this.B, this.H);
            } else {
                g.fillRect(this.L + 2, this.O + 2, this.H, this.B);
            }
            g.setColor(new Color(245, 245, 245));
            if (Geopro.hochformat) {
                g.fillRect(this.L, this.O, this.B, this.H);
            } else {
                g.fillRect(this.L, this.O, this.H, this.B);
            }
            g.setColor(Color.gray);
            if (Geopro.hochformat) {
                g.drawRect(this.L, this.O, this.B, this.H);
            } else {
                g.drawRect(this.L, this.O, this.H, this.B);
            }
            g.setColor(Color.white);
            if (Geopro.hochformat) {
                g.fillRect(this.L + this.R, this.O + this.R, this.B - 2 * this.R, this.H - 2 * this.R);
                g.setClip(this.L + this.R, this.O + this.R, this.B - 2 * this.R, this.H - 2 * this.R);
            } else {
                g.fillRect(this.L + this.R, this.O + this.R, this.H - 2 * this.R, this.B - 2 * this.R);
                g.setClip(this.L + this.R, this.O + this.R, this.H - 2 * this.R, this.B - 2 * this.R);
            }
            double f = 0.1 / Geopro.cm;
            if (DruckerFenster.this.dim == 1) {
                if (DruckerFenster.this.mitGraphik) {
                    String text = Geopro.algebraFenster.algebraAusgabe.getText();
                    g.setColor(Color.black);
                    int s = Geopro.algebraFenster.htmlGross;
                    g.setFont(new Font("Courier", 0, s));
                    g.translate(this.L + this.R, this.O + this.R);
                    double sk = f * (double)Geopro.skalierung;
                    g.scale(sk, sk);
                    String[] zeilen = text.split(Geopro.cr);
                    int y = 0;
                    int a = s + s / 3;
                    String[] stringArray = zeilen;
                    int n = zeilen.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String zeile = stringArray[n2];
                        g.drawString(zeile, 0, y += a);
                        ++n2;
                    }
                }
            } else {
                int l = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].links);
                int o = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].oben);
                int b = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].breite);
                int h = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].hoehe);
                if (DruckerFenster.this.mitGraphik) {
                    g.translate(this.L + this.R, this.O + this.R);
                    double sk = f * (double)Geopro.skalierung;
                    g.scale(sk, sk);
                    g.translate(-l, -o);
                    g.clipRect(l, o, b + 1, h + 1);
                    if (DruckerFenster.this.dim == 2) {
                        Geopro.plantafel.zeichnen(g, false);
                    } else if (Geopro.riss == 1) {
                        Geopro.bildtafel.zeichnen(g, false);
                    } else {
                        g.setFont(new Font("Arial", 0, 24));
                        g.setColor(Color.red);
                        g.drawString("Kein Ausdruck in dieser Darstellungsart!", 10, 220);
                    }
                    g.translate(l, o);
                    g.scale(1.0 / sk, 1.0 / sk);
                    g.translate(-(this.L + this.R), -(this.O + this.R));
                } else {
                    g.setFont(new Font("Arial", 0, 9));
                    g.setColor(Color.red);
                    g.drawString(String.valueOf((int)((double)(10 * b) / Geopro.cm)) + "mm x " + (int)((double)(10 * h) / Geopro.cm) + "mm", this.L + this.R + 5, this.O + 2 * this.R);
                }
                g.setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, Geopro.muster3, 0.0f));
                double BB = f * Geopro.konstruktion[Konstruktion.nummer].breite;
                double HH = f * Geopro.konstruktion[Konstruktion.nummer].hoehe;
                g.setColor(Color.red);
                g.draw(new Rectangle2D.Double(this.L + this.R, this.O + this.R, BB * (double)Geopro.skalierung, HH * (double)Geopro.skalierung));
            }
        }
    }
}

