/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

class Plantafel
extends Bildriss {
    private static final long serialVersionUID = 1L;
    static String xName = "x";
    static String yName = "y";
    static int Xa = 1000;
    static int Xb = -1000;
    static int Ya = 1000;
    static int Yb = -1000;
    static int re = 0;

    Plantafel() {
    }

    @Override
    void standard() {
        Geopro.zoom = 1.0;
        Geopro.xFaktor = 1;
        Geopro.yFaktor = 1;
        Geopro.mitteX = 142;
        Geopro.mitteY = 341;
        if (Geopro.riss == 0) {
            Geopro.rollGraphik0.getViewport().setViewPosition(new Point(0, 0));
        }
    }

    void suchen(int art, int nr) {
        Vektor2D V = new Vektor2D(0.0, 0.0);
        Vektor2D P = new Vektor2D(0.0, 0.0);
        int k = Kommentar.kommentarHoehe();
        int l = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].links);
        int o = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].oben + (double)k);
        int b = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].breite);
        int h = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].hoehe - (double)k);
        Vektor2D M = new Vektor2D(l + b / 2, o + h / 2);
        Vektor2D O = new Vektor2D(X0, Y0);
        switch (art) {
            case 1: {
                P = Bildtafel.riss(0, Geopro.punkt[nr].tripel);
                break;
            }
            case 2: {
                P = Bildtafel.riss(0, Geopro.gerade[nr].tripel);
                break;
            }
            case 3: {
                P = Bildtafel.riss(0, Geopro.vieleck[nr].punkte[0]);
            }
        }
        V = Vektor2D.weg(M, P);
        M = Vektor2D.und(O, V);
        Geopro.mitteX = M.X;
        Geopro.mitteY = M.Y;
    }

    @Override
    void aktuell() {
        X0 = Geopro.mitteX;
        Y0 = Geopro.mitteY;
        if (!Geopro.ursprung) {
            X0 = (int)(Geopro.zoom * (double)Geopro.mitteX);
            Y0 = (int)(Geopro.zoom * (double)Geopro.mitteY);
        }
        faktor = Geopro.faktor;
        xFaktor = Geopro.faktor / (double)Geopro.xFaktor;
        yFaktor = Geopro.faktor / (double)Geopro.yFaktor;
        Geopro.blickrichtung = new Vektor3D(0.0, 0.0, 1.0);
    }

    @Override
    Vektor2D bildPunkt(Vektor3D p) {
        return new Vektor2D((int)((double)X0 + xFaktor * p.x), (int)((double)Y0 - yFaktor * p.y));
    }

    @Override
    Vektor2D rBildPunkt(Vektor3D p) {
        return new Vektor2D((double)X0 + xFaktor * p.x, (double)Y0 - yFaktor * p.y);
    }

    void objekteZeichnen(Graphics2D g) {
        block65: {
            int ii;
            block64: {
                ii = 0;
                if (!Geopro.layerfolge) break block64;
                switch (Geopro.reihenfolge) {
                    case 1: {
                        int j = 0;
                        while (j < 5) {
                            ii = 0;
                            int i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].vieleckZahl) {
                                if (Geopro.vieleck[i].maxLayer() == j) {
                                    Geopro.vieleck[i].zeichnen(g, 0, i == Vieleck.nummer || i == Vieleck.markiert || Geopro.vieleck[i].gefangen);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].geradenZahl) {
                                if (Geopro.gerade[i].maxLayer() == j) {
                                    Geopro.gerade[i].zeichnen(g, 0, i == Gerade.nummer || Geopro.gerade[i].gefangen || i == Gerade.markiert, i == Gerade.nummer2 || Geopro.gerade[i].gefangen || i == Gerade.markiert2);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].gebietZahl) {
                                if (Geopro.gebiet[i].maxLayer() == j) {
                                    Geopro.gebiet[i].zeichnen(g, 0, i == Gebiet.nummer || i == Gebiet.markiert || Geopro.gebiet[i].gefangen);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].markenZahl) {
                                if (Geopro.marke[i].maxLayer() == j) {
                                    Geopro.marke[i].zeichnen(g, 0, i == Marke.nummer || i == Marke.markiert);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].ortslinienZahl) {
                                if (Geopro.ortslinie[i].maxLayer() == j) {
                                    Geopro.ortslinie[i].zeichnen(g, 0, i == Ortslinie.nummer || i == Ortslinie.markiert || Geopro.ortslinie[i].gefangen);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].punktZahl) {
                                if (Geopro.punkt[i].maxLayer() == j) {
                                    Geopro.punkt[i].zeichnen(g, 0, i == Punkt.nummer || i == Punkt.markiert || Geopro.punkt[i].gefangen);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].messZahl) {
                                if (Geopro.mass[i].maxLayer() == j) {
                                    Geopro.mass[i].zeichnen(g, 0, i == Messen.nummer || i == Messen.markiert);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].abbildZahl) {
                                if (Geopro.abbild[i].maxLayer() == j) {
                                    Geopro.abbild[i].zeichnen(g, this, ii, i == Abbild.nummer || i == Abbild.markiert || Geopro.abbild[i].gefangen);
                                    ++ii;
                                }
                                ++i;
                            }
                            ++j;
                        }
                        break block65;
                    }
                    case 2: {
                        int j = 0;
                        while (j < 5) {
                            ii = 0;
                            int i = 0;
                            while (i < Geopro.konstruktion[Konstruktion.nummer].stand) {
                                int nr = Geopro.konstruktion[Konstruktion.nummer].schritt[i].nummer;
                                switch (Geopro.konstruktion[Konstruktion.nummer].schritt[i].art) {
                                    case 1: {
                                        if (Geopro.punkt[nr].maxLayer() != j) break;
                                        Geopro.punkt[nr].zeichnen(g, 0, nr == Punkt.nummer || nr == Punkt.markiert);
                                        break;
                                    }
                                    case 2: {
                                        if (Geopro.gerade[nr].maxLayer() != j) break;
                                        Geopro.gerade[nr].zeichnen(g, 0, nr == Gerade.nummer || nr == Gerade.markiert || Geopro.gerade[nr].gefangen, nr == Gerade.nummer2 || nr == Gerade.markiert2 || Geopro.gerade[nr].gefangen);
                                        break;
                                    }
                                    case 3: {
                                        if (Geopro.vieleck[nr].maxLayer() != j) break;
                                        Geopro.vieleck[nr].zeichnen(g, 0, nr == Vieleck.nummer || nr == Vieleck.markiert || Geopro.vieleck[nr].gefangen);
                                        break;
                                    }
                                    case 6: {
                                        if (Geopro.mass[nr].maxLayer() != j) break;
                                        Geopro.mass[nr].zeichnen(g, 0, nr == Messen.nummer || nr == Messen.markiert);
                                        break;
                                    }
                                    case 7: {
                                        if (Geopro.abbild[nr].maxLayer() != j) break;
                                        Geopro.abbild[nr].zeichnen(g, this, ii, nr == Abbild.nummer || nr == Abbild.markiert || Geopro.abbild[nr].gefangen);
                                        ++ii;
                                        break;
                                    }
                                    case 8: {
                                        if (Geopro.marke[nr].maxLayer() != j) break;
                                        Geopro.marke[nr].zeichnen(g, 0, nr == Marke.nummer || nr == Marke.markiert);
                                        break;
                                    }
                                    case 9: {
                                        if (Geopro.ortslinie[nr].maxLayer() != j) break;
                                        Geopro.ortslinie[nr].zeichnen(g, 0, nr == Ortslinie.nummer || nr == Ortslinie.markiert || Geopro.ortslinie[nr].gefangen);
                                        break;
                                    }
                                    case 10: {
                                        if (Geopro.gebiet[nr].maxLayer() != j) break;
                                        Geopro.gebiet[nr].zeichnen(g, 0, nr == Gebiet.nummer || nr == Gebiet.markiert || Geopro.gebiet[nr].gefangen);
                                    }
                                }
                                ++i;
                            }
                            ++j;
                        }
                        break block0;
                    }
                }
                break block65;
            }
            switch (Geopro.reihenfolge) {
                case 1: {
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].vieleckZahl) {
                        if (Geopro.vieleck[i].maxLayer() >= 0) {
                            Geopro.vieleck[i].zeichnen(g, 0, i == Vieleck.nummer || i == Vieleck.markiert || Geopro.vieleck[i].gefangen);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].geradenZahl) {
                        if (Geopro.gerade[i].maxLayer() >= 0) {
                            Geopro.gerade[i].zeichnen(g, 0, i == Gerade.nummer || Geopro.gerade[i].gefangen || i == Gerade.markiert, i == Gerade.nummer2 || Geopro.gerade[i].gefangen || i == Gerade.markiert2);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].gebietZahl) {
                        if (Geopro.gebiet[i].maxLayer() >= 0) {
                            Geopro.gebiet[i].zeichnen(g, 0, i == Gebiet.nummer || i == Gebiet.markiert || Geopro.gebiet[i].gefangen);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].markenZahl) {
                        if (Geopro.marke[i].maxLayer() >= 0) {
                            Geopro.marke[i].zeichnen(g, 0, i == Marke.nummer || i == Marke.markiert || Geopro.marke[i].gefangen);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].ortslinienZahl) {
                        if (Geopro.ortslinie[i].maxLayer() >= 0) {
                            Geopro.ortslinie[i].zeichnen(g, 0, i == Ortslinie.nummer || i == Ortslinie.markiert || Geopro.ortslinie[i].gefangen);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].punktZahl) {
                        if (Geopro.punkt[i].maxLayer() >= 0) {
                            Geopro.punkt[i].zeichnen(g, 0, i == Punkt.nummer || i == Punkt.markiert || Geopro.punkt[i].gefangen);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].messZahl) {
                        if (Geopro.mass[i].maxLayer() >= 0) {
                            Geopro.mass[i].zeichnen(g, 0, i == Messen.nummer || i == Messen.markiert);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].abbildZahl) {
                        if (Geopro.abbild[i].maxLayer() >= 0) {
                            Geopro.abbild[i].zeichnen(g, this, ii, i == Abbild.nummer || i == Abbild.markiert || Geopro.abbild[i].gefangen);
                            ++ii;
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    ii = 0;
                    int i = 0;
                    while (i < Geopro.konstruktion[Konstruktion.nummer].stand) {
                        int nr = Geopro.konstruktion[Konstruktion.nummer].schritt[i].nummer;
                        switch (Geopro.konstruktion[Konstruktion.nummer].schritt[i].art) {
                            case 1: {
                                if (Geopro.punkt[nr].maxLayer() < 0) break;
                                Geopro.punkt[nr].zeichnen(g, 0, nr == Punkt.nummer || nr == Punkt.markiert);
                                break;
                            }
                            case 2: {
                                if (Geopro.gerade[nr].maxLayer() < 0) break;
                                Geopro.gerade[nr].zeichnen(g, 0, nr == Gerade.nummer || nr == Gerade.markiert || Geopro.gerade[nr].gefangen, nr == Gerade.nummer2 || nr == Gerade.markiert2 || Geopro.gerade[nr].gefangen);
                                break;
                            }
                            case 3: {
                                if (Geopro.vieleck[nr].maxLayer() < 0) break;
                                Geopro.vieleck[nr].zeichnen(g, 0, nr == Vieleck.nummer || nr == Vieleck.markiert || Geopro.vieleck[nr].gefangen);
                                break;
                            }
                            case 6: {
                                if (Geopro.mass[nr].maxLayer() < 0) break;
                                Geopro.mass[nr].zeichnen(g, 0, nr == Messen.nummer || nr == Messen.markiert);
                                break;
                            }
                            case 7: {
                                if (Geopro.abbild[nr].maxLayer() < 0) break;
                                Geopro.abbild[nr].zeichnen(g, this, ii, nr == Abbild.nummer || nr == Abbild.markiert || Geopro.abbild[nr].gefangen);
                                ++ii;
                                break;
                            }
                            case 8: {
                                if (Geopro.marke[nr].maxLayer() < 0) break;
                                Geopro.marke[nr].zeichnen(g, 0, nr == Marke.nummer || nr == Marke.markiert);
                                break;
                            }
                            case 9: {
                                if (Geopro.ortslinie[nr].maxLayer() < 0) break;
                                Geopro.ortslinie[nr].zeichnen(g, 0, nr == Ortslinie.nummer || nr == Ortslinie.markiert || Geopro.ortslinie[nr].gefangen);
                                break;
                            }
                            case 10: {
                                if (Geopro.gebiet[nr].maxLayer() < 0) break;
                                Geopro.gebiet[nr].zeichnen(g, 0, nr == Gebiet.nummer || nr == Gebiet.markiert || Geopro.gebiet[nr].gefangen);
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        Geopro.vorschauVieleck.zeichnen(g, 0, false);
        Geopro.vorschauGerade.zeichnen(g, 0, false, false);
        Geopro.vorschauMarke.zeichnen(g, 0, false);
        Geopro.vorschauOrtslinie.zeichnen(g, 0, false);
        Geopro.vorschauPunkt.zeichnen(g, 0, false);
        Geopro.vorschauMessen.zeichnen(g, 0, false);
    }

    void achsenZeichnen(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int rr = 12;
        re = Geopro.achsenart == 5 ? 7 : 0;
        int achsengross = Geopro.schriftgross[Geopro.schriftGross];
        int b = 3;
        int h = 3;
        int k = Kommentar.kommentarHoehe();
        if (k > 0) {
            k += 3;
        }
        int l = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].links);
        int o = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].oben + (double)k);
        int r = l + Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].breite);
        int u = o + Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].hoehe - (double)k);
        o += 15;
        r -= 12 + re;
        if (Geopro.schwarzweiss) {
            g.setColor(Geopro.farbe[10]);
        } else {
            g.setColor(Geopro.achsen);
        }
        g.setStroke(new BasicStroke(0.6f));
        if (X0 > l + rr + Geopro.skalenschriftZugabe && X0 < r - 8 && Y0 > o + 5 && Y0 < u - rr - Geopro.skalenschriftZugabe) {
            if (Geopro.konstruktion[Konstruktion.nummer].stelle == 12) {
                if (Geopro.achsenart == 5) {
                    g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 1, achsengross + 1));
                } else {
                    g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 3, achsengross + 1));
                }
            } else if (Geopro.achsenart == 5) {
                g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, achsengross));
            } else {
                g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 2, achsengross));
            }
            g.draw(new Line2D.Double(l, Y0, r, Y0));
            int[] eckX1 = new int[]{r + 1, r - b, r - b};
            int[] eckY1 = new int[]{Y0, Y0 - h, Y0 + h + 1};
            Polygon drei1 = new Polygon(eckX1, eckY1, 3);
            g.fillPolygon(drei1);
            g.drawString(xName, r + xSchriftX + 1, Y0 + xSchriftY - 1);
            if (Geopro.konstruktion[Konstruktion.nummer].stelle == 13) {
                if (Geopro.achsenart == 5) {
                    g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 1, achsengross + 1));
                } else {
                    g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 3, achsengross + 1));
                }
            } else if (Geopro.achsenart == 5) {
                g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, achsengross));
            } else {
                g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 2, achsengross));
            }
            g.draw(new Line2D.Double(X0, o, X0, u));
            int[] eckX2 = new int[]{X0, X0 - h, X0 + h + 1};
            int[] eckY2 = new int[]{o - 1, o + b, o + b};
            Polygon drei2 = new Polygon(eckX2, eckY2, 3);
            g.fillPolygon(drei2);
            int dx = 0;
            int dy = 0;
            if (Geopro.achsenart == 5) {
                dx = 3;
                dy = 2;
            }
            g.drawString(yName, X0 + ySchriftX - dx, o + ySchriftY - 2 + dy);
            g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 10));
        }
    }

    static int xSkalenWert() {
        int xF = Geopro.xFaktor;
        switch (Geopro.xFaktor) {
            case 1: {
                if (Geopro.zoom < 0.15) {
                    xF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    xF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.5)) break;
                xF *= 2;
                break;
            }
            case 2: {
                if (Geopro.zoom < 0.15) {
                    xF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    xF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.6)) break;
                xF *= 2;
                break;
            }
            case 5: {
                if (Geopro.zoom < 0.15) {
                    xF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    xF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.7)) break;
                xF *= 2;
                break;
            }
            case 10: {
                if (Geopro.zoom < 0.15) {
                    xF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    xF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.8)) break;
                xF *= 2;
                break;
            }
            case 20: {
                if (Geopro.zoom < 0.15) {
                    xF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    xF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 1.0)) break;
                xF *= 2;
            }
        }
        return xF;
    }

    static int ySkalenWert() {
        int yF = Geopro.yFaktor;
        switch (Geopro.yFaktor) {
            case 1: {
                if (Geopro.zoom < 0.15) {
                    yF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    yF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.5)) break;
                yF *= 2;
                break;
            }
            case 2: {
                if (Geopro.zoom < 0.15) {
                    yF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    yF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.6)) break;
                yF *= 2;
                break;
            }
            case 5: {
                if (Geopro.zoom < 0.15) {
                    yF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    yF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.7)) break;
                yF *= 2;
                break;
            }
            case 10: {
                if (Geopro.zoom < 0.15) {
                    yF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    yF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 0.8)) break;
                yF *= 2;
                break;
            }
            case 20: {
                if (Geopro.zoom < 0.15) {
                    yF *= 10;
                    break;
                }
                if (Geopro.zoom < 0.25) {
                    yF *= 5;
                    break;
                }
                if (!(Geopro.zoom < 1.0)) break;
                yF *= 2;
            }
        }
        return yF;
    }

    void skalaZeichnen(Graphics2D g) {
        int b;
        int rr = 12;
        re = Geopro.achsenart == 5 ? 7 : 0;
        int skalengross = Geopro.skalenschriftZugabe + 9;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double fx = xFaktor;
        double fy = yFaktor;
        fx = Geopro.skalenart != 2 ? xFaktor : xFaktor * Math.PI;
        int B = this.getBounds().width;
        int H = this.getBounds().height;
        double L = (double)X0 - fx * (double)((int)((double)X0 / fx) + 1);
        double R = (double)X0 + fx * ((double)(B - X0) / fx + 1.0);
        double O = (double)Y0 - fy * (double)((int)((double)Y0 / fy) + 1);
        double U = (double)Y0 + fy * ((double)(H - Y0) / fy + 1.0);
        int k = Kommentar.kommentarHoehe();
        int l = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].links);
        int o = Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].oben + (double)k);
        int r = l + Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].breite);
        int u = o + Skalar.runde(Geopro.konstruktion[Konstruktion.nummer].hoehe - (double)k);
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, skalengross));
        if (Geopro.schwarzweiss) {
            g.setColor(Geopro.farbe[10]);
        } else {
            g.setColor(Geopro.achsen);
        }
        g.setStroke(new BasicStroke(0.6f));
        String Xs = "";
        String Ys = "";
        Xa = 1000;
        Xb = -1000;
        Ya = 1000;
        Yb = -1000;
        double x = L;
        while (x <= R) {
            int X;
            if (x > (double)(l + 6) && x < (double)(r - 20 - re) && X0 > l + rr + Geopro.skalenschriftZugabe && X0 < r - 20 && o < Y0 - 20 && Y0 < u - rr - Geopro.skalenschriftZugabe && (X = (int)Math.round((x - (double)X0) / fx)) != 0) {
                Xs = String.valueOf(X);
                if (X < Xa) {
                    Xa = X;
                }
                if (X > Xb) {
                    Xb = X;
                }
                if (Geopro.skalenart == 2) {
                    Xs = Xs.equals("1") ? "\u03c0" : (Xs.equals("-1") ? "-\u03c0" : String.valueOf(Xs) + '\u03c0');
                }
                b = g.getFontMetrics(g.getFont()).stringWidth(Xs);
                int xF = Plantafel.xSkalenWert();
                if (X % xF == 0) {
                    g.drawString(Xs, (int)x - b / 2, Y0 + 11 + Geopro.skalenschriftZugabe);
                    g.draw(new Line2D.Double(x, Y0 - 2, x, Y0 + 2));
                }
            }
            x += fx;
        }
        double y = O;
        while (y <= U) {
            int Y = Skalar.runde(((double)Y0 - y) / fy);
            Ys = String.valueOf(Y);
            if (Y != 0 && y > (double)(o + 25) && y < (double)(u - 5) && X0 > l + rr + Geopro.skalenschriftZugabe && X0 < r - 20 && o < Y0 - 20 && Y0 < u - rr - Geopro.skalenschriftZugabe) {
                if (Y > Yb) {
                    Yb = Y;
                }
                if (Y < Ya) {
                    Ya = Y;
                }
                b = g.getFontMetrics(g.getFont()).stringWidth(Ys) + 3;
                int yF = Plantafel.ySkalenWert();
                if (Y % yF == 0) {
                    g.drawString(Ys, X0 - b, (int)y + 3);
                    g.draw(new Line2D.Double(X0 - 2, y, X0 + 2, y));
                }
            }
            y += fy;
        }
    }

    void gitterZeichnen(Graphics2D g) {
        double f = Math.sqrt(3.0);
        double fx = Geopro.xFaktor;
        double fy = Geopro.yFaktor;
        int gitterart = Geopro.gitterart % 10;
        fx = Geopro.skalenart == 2 && gitterart <= 1 ? xFaktor * Math.PI / 2.0 : xFaktor;
        fy = gitterart <= 1 ? yFaktor : yFaktor * f;
        int B = this.getBounds().width;
        int H = this.getBounds().height;
        double L = (double)X0 - fx * (double)((int)((double)X0 / fx + 1.0));
        double R = (double)X0 + fx * (double)((int)((double)(B - X0) / fx + 1.0));
        double O = (double)Y0 - fy * (double)((int)((double)Y0 / fy + 1.0));
        double U = (double)Y0 + fy * (double)((int)((double)(H - Y0) / fy + 1.0));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(0.375f));
        g.setColor(Geopro.gitter);
        int xF = Plantafel.xSkalenWert();
        int yF = Plantafel.ySkalenWert();
        if (gitterart == 0) {
            double y = O;
            while (y <= U) {
                int Y = Skalar.runde(((double)Y0 - y) / fy);
                if (Y % yF == 0) {
                    g.draw(new Line2D.Double(L, y, R, y));
                }
                y += fy;
            }
            double x = L;
            while (x <= R) {
                int X = Skalar.runde((x - (double)X0) / fx);
                if (X % xF == 0) {
                    g.draw(new Line2D.Double(x, O, x, U));
                }
                x += fx;
            }
        } else if (gitterart == 2) {
            double x = L;
            while (x <= R) {
                double y = O;
                while (y <= U) {
                    g.draw(new Line2D.Double(x, y, x + fx, y + fy));
                    g.draw(new Line2D.Double(x + fx, y, x, y + fy));
                    g.draw(new Line2D.Double(x, y + fy / 2.0, x + fx, y + fy / 2.0));
                    g.draw(new Line2D.Double(x, y + fy, x + fx, y + fy));
                    y += fy;
                }
                x += fx;
            }
        } else {
            double d = 3.0;
            double r = d / 2.0;
            double x = L;
            while (x <= R) {
                int X = Skalar.runde((x - (double)X0) / fx);
                double y = O;
                while (y <= U) {
                    switch (gitterart) {
                        case 1: {
                            g.fill(new Ellipse2D.Double(x - r, y - r, d, d));
                            break;
                        }
                        case 3: {
                            g.fill(new Ellipse2D.Double(x - r, y - r, d, d));
                            g.fill(new Ellipse2D.Double(x + fx / 2.0 - r, y - fy / 2.0 - r, d, d));
                            break;
                        }
                        case 4: {
                            if (X % (3 * xF) != 0) {
                                g.fill(new Ellipse2D.Double(x - r, y - r, d, d));
                            }
                            if (X % (3 * xF) == 1 || X % (3 * xF) == -2) break;
                            g.fill(new Ellipse2D.Double(x + fx / 2.0 - r, y - fy / 2.0 - r, d, d));
                        }
                    }
                    y += fy;
                }
                x += fx;
            }
        }
    }

    void aktuelleKoordinaten(Graphics2D g) {
        int R = 10;
        if (Bildtafel.mausX > 0 && Bildtafel.mausY > 0) {
            int X = Bildtafel.mausX - R;
            int Y = Bildtafel.mausY - R;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 9));
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.darkGray);
            g.drawOval(X, Y, 2 * R, 2 * R);
            g.drawLine(X + R, Y + R, X + R, Y + R);
            g.drawLine(X + 2 * R, Y + R, X + 3 * R, Y + R);
            g.drawLine(X - R, Y + R, X, Y + R);
            g.drawLine(X + R, Y - R, X + R, Y);
            g.drawLine(X + R, Y + 2 * R, X + R, Y + 3 * R);
            String xs = Skalar.runde((double)(X - X0 + R) / xFaktor, Geopro.stellen);
            int b = g.getFontMetrics(g.getFont()).stringWidth(xs);
            g.drawString(xs, X + R - b / 2, Y - R - 4);
            g.drawString(Skalar.runde((double)(-(Y - Y0 + R)) / yFaktor, Geopro.stellen), X + 3 * R + 4, Y + R + R / 2 - 1);
        }
        if (Bildtafel.mausZentrum) {
            int R1 = 5;
            int X1 = this.bildPunkt((Vektor3D)Punkt.drehPunkt).X;
            int Y1 = this.bildPunkt((Vektor3D)Punkt.drehPunkt).Y;
            g.setStroke(new BasicStroke(1.5f));
            g.drawOval(X1 - R1, Y1 - R1, 2 * R1, 2 * R1);
            g.fillOval(X1 - 1, Y1 - 1, 2, 2);
        }
    }

    void basislinieZeichnen(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 9));
        Vektor2D v = Vektor2D.weg(Geopro.hilfe[1], Geopro.hilfe[2]);
        Vektor2D a = Vektor2D.und(Geopro.hilfe[1], v);
        Vektor2D b = Vektor2D.und(Geopro.hilfe[2], Vektor2D.mal(-1.0, v));
        g.setColor(Color.gray);
        g.fill(new Ellipse2D.Double(Geopro.hilfe[0].x - 1.0, Geopro.hilfe[0].y - 1.0, 2.0, 2.0));
        g.fill(new Ellipse2D.Double(a.x - 1.0, a.y - 1.0, 2.0, 2.0));
        g.fill(new Ellipse2D.Double(b.x - 1.0, b.y - 1.0, 2.0, 2.0));
        if (magnetFang) {
            g.setStroke(new BasicStroke(0.5f));
        } else {
            g.setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, Geopro.muster3, 0.0f));
        }
        g.draw(new Line2D.Double(a.x, a.y, b.x, b.y));
        double winkel = Geopro.hilfeW;
        if (winkel < 0.0) {
            winkel += 180.0;
        }
        if (winkel > 90.0) {
            winkel -= 180.0;
        }
        winkel = Math.abs(winkel);
        String s = String.valueOf(Skalar.runde(winkel, Geopro.stellen)) + Geopro.grad;
        g.setColor(Color.gray);
        g.drawString(s, (int)b.x + 5, (int)b.y - 5);
    }

    void transporteurZeichnen(Graphics2D g, int stelle) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 9));
        g.setColor(Geopro.bereich);
        float tp1 = 0.3f;
        float tp2 = 0.3f;
        if (stelle == 8) {
            tp1 = 0.6f;
        } else if (stelle == 7) {
            tp2 = 0.6f;
        }
        double R = 0.75 * Geopro.hilfeR;
        double w = 0.0;
        double R1 = R - 20.0;
        double R2 = R;
        int i = 1;
        while (i < 36) {
            w = (Geopro.hilfeW + (double)(i * 5)) * Math.PI / 180.0;
            R1 = i == 18 ? 0.0 : (i == 9 || i == 27 ? R - 20.0 : (i % 2 == 0 ? R - 10.0 : R - 5.0));
            g.setStroke(new BasicStroke(0.5f, 1, 1));
            g.draw(new Line2D.Double(Geopro.hilfe[0].x + R1 * Math.cos(w), Geopro.hilfe[0].y - R1 * Math.sin(w), Geopro.hilfe[0].x + R2 * Math.cos(w), Geopro.hilfe[0].y - R2 * Math.sin(w)));
            ++i;
        }
        R2 = R + 1.0;
        double ww = Geopro.hilfeW * Math.PI / 180.0;
        Arc2D.Double k = new Arc2D.Double(Geopro.hilfe[0].x - R2, Geopro.hilfe[0].y - R2, 2.0 * R2, 2.0 * R2, Geopro.hilfeW, 180.0, 0);
        Color ff = Color.gray;
        g.setColor(new Color((float)((double)ff.getRed() / 255.0), (float)((double)ff.getGreen() / 255.0), (float)((double)ff.getBlue() / 255.0), tp2));
        g.fill(k);
        g.setStroke(new BasicStroke(0.5f, 1, 1));
        g.draw(new Line2D.Double(Geopro.hilfe[0].x - R2 * Math.cos(ww), Geopro.hilfe[0].y + R2 * Math.sin(ww), Geopro.hilfe[0].x + R2 * Math.cos(ww), Geopro.hilfe[0].y - R2 * Math.sin(ww)));
        g.setColor(Color.gray);
        g.draw(k);
        AffineTransform t = g.getTransform();
        double rad = -Geopro.hilfeW * Math.PI / 180.0;
        g.rotate(rad, Geopro.hilfe[0].x, Geopro.hilfe[0].y);
        double winkel = Geopro.hilfeW;
        if (winkel < 0.0) {
            winkel += 360.0;
        }
        if (winkel > 180.0) {
            winkel -= 360.0;
        }
        g.drawString(String.valueOf(Skalar.runde(winkel, Geopro.stellen)) + Geopro.grad, (int)Geopro.hilfe[0].x + 2, (int)Geopro.hilfe[0].y - 2);
        g.setTransform(t);
        R2 = Geopro.hilfeR;
        double D = R2 / 6.0;
        g.setColor(Color.gray);
        double dX = D * Math.sin(ww);
        double dY = D * Math.cos(ww);
        double X5 = Geopro.hilfe[0].x + 0.5 * dX;
        double Y5 = Geopro.hilfe[0].y + 0.5 * dY;
        if (Geopro.magnetFenster.mitmag) {
            Vektor2D v = Vektor2D.weg(Geopro.hilfe[1], Geopro.hilfe[2]);
            Vektor2D a = Vektor2D.und(Geopro.hilfe[1], v);
            Vektor2D b = Vektor2D.und(Geopro.hilfe[2], Vektor2D.mal(-1.0, v));
            g.setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, Geopro.muster3, 0.0f));
            g.setColor(Color.gray);
            g.draw(new Line2D.Double(a.x, a.y, Geopro.hilfe[1].x, Geopro.hilfe[1].y));
            g.draw(new Line2D.Double(b.x, b.y, Geopro.hilfe[2].x, Geopro.hilfe[2].y));
        }
        GeneralPath vier = new GeneralPath();
        vier.moveTo(Geopro.hilfe[4].x, Geopro.hilfe[4].y);
        int i2 = 1;
        while (i2 < 5) {
            vier.lineTo(Geopro.hilfe[i2].x, Geopro.hilfe[i2].y);
            ++i2;
        }
        vier.closePath();
        g.setColor(new Color((float)((double)ff.getRed() / 255.0), (float)((double)ff.getGreen() / 255.0), (float)((double)ff.getBlue() / 255.0), tp1));
        g.fill(vier);
        g.setColor(Color.gray);
        g.setStroke(new BasicStroke(0.5f, 1, 1));
        g.draw(vier);
        g.draw(new Line2D.Double(Geopro.hilfe[0].x, Geopro.hilfe[0].y, X5, Y5));
        double X = 0.0;
        double Y = 0.0;
        int anz = (int)(R2 / Geopro.faktor);
        double d = 0.2;
        int i3 = 1;
        while (i3 <= anz) {
            d = i3 % 10 == 0 ? 0.5 : (i3 % 5 == 0 ? 0.3 : 0.2);
            X = Geopro.hilfe[0].x + Geopro.faktor * Math.cos(ww) * (double)i3;
            Y = Geopro.hilfe[0].y - Geopro.faktor * Math.sin(ww) * (double)i3;
            g.draw(new Line2D.Double(X, Y, X + d * dX, Y + d * dY));
            X = Geopro.hilfe[0].x - Geopro.faktor * Math.cos(ww) * (double)i3;
            Y = Geopro.hilfe[0].y + Geopro.faktor * Math.sin(ww) * (double)i3;
            g.draw(new Line2D.Double(X, Y, X + d * dX, Y + d * dY));
            ++i3;
        }
    }

    @Override
    void zeichnen(Graphics gg, boolean rahmen) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.aktuell();
        boolean mitFang = Geopro.konstruktion[Konstruktion.nummer].stelle >= 0 && Geopro.konstruktion[Konstruktion.nummer].stelle < 7;
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 10));
        g.setColor(Geopro.hinter);
        g.fillRect(0, 0, this.getBounds().width + 1, this.getBounds().height + 1);
        if (rahmen) {
            Geopro.konstruktion[Konstruktion.nummer].bereichUnterlage(g, mitFang);
        }
        if (Geopro.mitBild && Geopro.bildHinten) {
            this.bildZeichnen(g, rahmen);
        }
        if (Geopro.mitGitter && Geopro.gitterhinten) {
            this.gitterZeichnen(g);
        }
        if (Geopro.mitAchsen && Geopro.achsenhinten) {
            this.achsenZeichnen(g);
            if (Geopro.skalenart > 0) {
                this.skalaZeichnen(g);
            }
        }
        this.objekteZeichnen(g);
        if (Geopro.mitBild && !Geopro.bildHinten) {
            this.bildZeichnen(g, rahmen);
        }
        if (Geopro.mitGitter && !Geopro.gitterhinten) {
            this.gitterZeichnen(g);
        }
        if (Geopro.mitAchsen && !Geopro.achsenhinten) {
            this.achsenZeichnen(g);
            if (Geopro.skalenart > 0) {
                this.skalaZeichnen(g);
            }
        }
        if (Geopro.hilfslinien == 2 && rahmen) {
            this.basislinieZeichnen(g);
        }
        if (Geopro.hilfslinien == 1 && rahmen) {
            this.transporteurZeichnen(g, Geopro.konstruktion[Konstruktion.nummer].stelle);
        }
        if (Kommentar.mitKommentar) {
            Kommentar.zeichnen(g);
        }
        this.unterschriftZeichnen(g);
        if (rahmen) {
            Geopro.konstruktion[Konstruktion.nummer].bereichZeichnen(g, Geopro.konstruktion[Konstruktion.nummer].stelle >= 0 && Geopro.konstruktion[Konstruktion.nummer].stelle <= 6);
        }
        this.aktuelleKoordinaten(g);
        Attribute.schieberAnpassen();
    }

    public void paintComponent(Graphics2D g) {
        this.zeichnen(g, true);
    }

    @Override
    void auffrischen() {
        Geopro.graphikPanel.repaint();
    }

    @Override
    void hilfsPunkt(int X, int Y) {
        Geopro.punkt[Punkt.max - 1].tripel = new Vektor3D((double)(X - X0) / (1.0 * xFaktor), (double)(Y0 - Y) / (1.0 * yFaktor), 0.0);
    }

    @Override
    void festPunkt(int t, String n, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = new int[5];
        int i = 0;
        while (i < 5) {
            l[i] = Geopro.aktLayer[i];
            ++i;
        }
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(100, n, Skalar.dezimalZahl(Geopro.exakt, (double)(X - X0) / xFaktor), Skalar.dezimalZahl(Geopro.exakt, (double)(Y0 - Y) / yFaktor), "0.0", f, s, l, 0, 0);
    }

    @Override
    void basisPunkt(int t, String n, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = new int[5];
        int i = 0;
        while (i < 5) {
            l[i] = Geopro.aktLayer[i];
            ++i;
        }
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(101, n, (double)(X - X0) / xFaktor, (double)(Y0 - Y) / yFaktor, 0.0, f, s, l, 0, 0);
    }

    @Override
    void neuerBasisPunkt(boolean oben, int X, int Y) {
        this.neuerGleitPunkt(X, Y);
    }

    @Override
    void basisGleitPunkt(int t, int X, int Y) {
        Geopro.punkt[Punkt.nummer].typ = t;
        this.neuerGleitPunkt(X, Y);
    }

    @Override
    void gleitBasisPunkt(int t, int g, int X, int Y) {
        Geopro.punkt[Punkt.nummer].typ = t;
        Geopro.punkt[Punkt.nummer].her1 = g;
        this.neuerGleitPunkt(X, Y);
    }

    @Override
    void gleitPunkt(int t, String n, int g, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = new int[5];
        int i = 0;
        while (i < 5) {
            l[i] = Geopro.aktLayer[i];
            ++i;
        }
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(t, n, g, (double)(X - X0) / xFaktor, (double)(Y0 - Y) / yFaktor, 0.0, f, s, l, 0, 0);
    }

    @Override
    void neuerGleitPunkt(int X, int Y) {
        magnetFang = false;
        if (Geopro.hilfslinien == 2) {
            double d = 100.0;
            Vektor3D U = new Vektor3D((double)X - Geopro.hilfe[0].x, (double)Y - Geopro.hilfe[0].y, 0.0);
            double w = Math.PI / 180 * Geopro.hilfeW;
            Vektor3D W = new Vektor3D(Math.cos(w), -Math.sin(w), 0.0);
            Vektor3D V = Vektor3D.mal(Vektor3D.skap(U, W), W);
            Vektor3D Q = Vektor3D.und(new Vektor3D(Geopro.hilfe[0].x, Geopro.hilfe[0].y, 0.0), V);
            d = Vektor3D.norm(Vektor3D.weg(Q, new Vektor3D(X, Y, 0.0)));
            if (d < 10.0) {
                magnetFang = true;
            }
        }
        Geopro.punkt[Punkt.nummer].neueWerte((double)(X - X0) / xFaktor, (double)(Y0 - Y) / yFaktor, 0.0);
    }
}

