/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class Seitenriss
extends Grundriss {
    private static final long serialVersionUID = 1L;

    Seitenriss() {
    }

    @Override
    Vektor2D rBildPunkt(Vektor3D p) {
        return new Vektor2D((double)X0 - faktor * p.x, (double)Y0 - faktor * p.z);
    }

    @Override
    Vektor2D bildPunkt(Vektor3D p) {
        return new Vektor2D(Skalar.runde((double)X0 - faktor * p.x), Skalar.runde((double)Y0 - faktor * p.z));
    }

    @Override
    void aktuell() {
        spezialRiss = 3;
        X0 = Geopro.mitteX / 2 + schX;
        Y0 = Geopro.mitteY / 2 + schY;
        kante = Geopro.kante;
        faktor = Geopro.faktor / 2.0;
        Geopro.blickrichtung = new Vektor3D(0.0, 1.0, 0.0);
    }

    @Override
    void achsenZeichnen(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(0.5f));
        switch (Geopro.hellHinten) {
            case 1: {
                g.setColor(Color.black);
                break;
            }
            case 0: {
                g.setColor(Color.white);
                break;
            }
            case 2: {
                g.setColor(Geopro.farbe[13]);
            }
        }
        Vektor3D o = new Vektor3D(0.0, 0.0, 0.0);
        Vektor3D z = new Vektor3D(0.0, 0.0, Geopro.kante);
        Vektor3D x = new Vektor3D(Geopro.kante, 0.0, 0.0);
        if (!Geopro.mitWuerfel) {
            this.linie3D(g, o, z);
            this.linie3D(g, o, x);
        }
        this.pfeil(g, o, z);
        this.pfeil(g, o, x);
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 2, 9));
        Vektor2D X = this.bildPunkt(z);
        Vektor2D Y = this.bildPunkt(x);
        g.drawString("z", X.X - 2, X.Y - 4);
        g.drawString("x", Y.X - 10, Y.Y + 2);
    }

    @Override
    boolean knopfSicht() {
        return false;
    }

    @Override
    String knopfText() {
        return "Seitenriss";
    }

    @Override
    public void zeichnen(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.aktuell();
        g.setFont(new Font(Geopro.schriftart[Geopro.schriftArt], 0, 10));
        g.setColor(Geopro.hinter);
        g.fillRect(0, 0, this.getBounds().width + 1, this.getBounds().height + 1);
        if (this.mit) {
            if (Geopro.mitGitter) {
                this.gitterZeichnen(g);
            }
            if (Geopro.mitWuerfel) {
                this.eckeZeichnen(g);
            }
            if (Geopro.mitAchsen) {
                this.achsenZeichnen(g);
            }
            this.objekteZeichnen(g, 3);
            if (Geopro.mitLampe) {
                this.lampeZeichnen(g, Geopro.konstruktion[Konstruktion.nummer].stelle);
            }
        }
        this.knopfZeichnen(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.zeichnen(g);
    }

    @Override
    void hilfsPunkt(int X, int Y) {
        Geopro.punkt[Punkt.max - 1].tripel = Punkt.nummer > -1 ? Geopro.punkt[Punkt.nummer].tripel : new Vektor3D((double)(X0 - X) / faktor, 0.0, (double)(Y0 - Y) / faktor);
    }

    @Override
    void festPunkt(int t, String n, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = Geopro.aktLayer;
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(t, n, "" + (double)(X0 - X) / faktor, "0.0", "" + (double)(Y0 - Y) / faktor, f, s, l, 0, 0);
    }

    @Override
    void basisPunkt(int t, String n, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        int f = Geopro.aktRand;
        int s = Geopro.aktStil;
        int[] l = Geopro.aktLayer;
        if (gr) {
            f = 0;
        }
        Geopro.punkt[Punkt.nummer] = new Punkt(t, n, (double)(X0 - X) / faktor, 0.0, (double)(Y0 - Y) / faktor, f, s, l, 0, 0);
    }

    @Override
    void gleitPunkt(int t, String n, int g, int X, int Y, boolean gr) {
        Punkt.nummer = Geopro.konstruktion[Konstruktion.nummer].punktZahl;
        Boolean ex = true;
        this.aktuell();
        Vektor3D p = new Vektor3D((double)(X0 - X) / faktor, 0.0, (double)(Y0 - Y) / faktor);
        int art = Geopro.gerade[g].art;
        if (art >= 4) {
            Vektor3D m = Geopro.gerade[g].tripel;
            Vektor3D v = Geopro.gerade[g].richtung;
            Vektor3D b = new Vektor3D(0.0, 1.0, 0.0);
            Ebene e = new Ebene(m, v);
            Gerade gb = new Gerade(p, b);
            Punkt s = new Punkt(e, gb, 0);
            if (s.exi) {
                p = s.tripel;
            } else {
                ex = false;
            }
        }
        if (ex.booleanValue()) {
            int f = Geopro.aktRand;
            int s = Geopro.aktStil;
            int[] l = new int[5];
            int i = 0;
            while (i < 5) {
                l[i] = Geopro.aktLayer[i];
                ++i;
            }
            Geopro.punkt[Punkt.nummer] = new Punkt(t, n, g, p.x, p.y, p.z, f, s, l, 0, 0);
        }
    }

    @Override
    void neuerBasisPunkt(boolean oben, int X, int Y) {
        this.aktuell();
        Geopro.punkt[Punkt.nummer].neueWerte((double)(X0 - X) / faktor, Geopro.punkt[Punkt.nummer].tripel.y, (double)(Y0 - Y) / faktor);
    }

    @Override
    void neuerGleitPunkt(int X, int Y) {
        boolean ex = true;
        this.aktuell();
        Vektor3D p = new Vektor3D((double)(X0 - X) / faktor, 0.0, (double)(Y0 - Y) / faktor);
        int nr = Geopro.punkt[Punkt.nummer].her1;
        if (nr >= 0) {
            int art = Geopro.gerade[nr].art;
            if (art >= 4) {
                Vektor3D m = Geopro.gerade[nr].tripel;
                Vektor3D v = Geopro.gerade[nr].richtung;
                Vektor3D b = new Vektor3D(0.0, 1.0, 0.0);
                Ebene e = new Ebene(m, v);
                Gerade gb = new Gerade(p, b);
                Punkt s = new Punkt(e, gb, 0);
                if (s.exi) {
                    p = s.tripel;
                } else {
                    ex = false;
                }
            }
        } else {
            ex = false;
        }
        if (ex) {
            Geopro.punkt[Punkt.nummer].neueWerte(p.x, p.y, p.z);
        }
    }

    @Override
    void gitterPunkt(int X, int Y) {
        Geopro.punkt[Punkt.nummer].neueWerte(Skalar.runde((double)(X0 - X) / faktor), Geopro.punkt[Punkt.nummer].tripel.y, Skalar.runde((double)(Y0 - Y) / faktor));
    }

    @Override
    double neuerKreisradius3D(boolean ganz, int i, int j, double X, double Y) {
        this.aktuell();
        double r = 0.0;
        Vektor3D p = Geopro.punkt[i].tripel;
        Vektor3D q = new Vektor3D(((double)X0 - X) / faktor, p.y, ((double)Y0 - Y) / faktor);
        Vektor3D en = Geopro.ebene[j].normale;
        double d = Vektor3D.skap(en, p);
        Ebene e = new Ebene(en, d);
        Vektor3D n = Geopro.blickrichtung;
        Gerade g = new Gerade(q, n);
        Punkt s = new Punkt(e, g, 0);
        if (s.exi) {
            q = s.tripel;
            r = Vektor3D.norm(Vektor3D.weg(p, q));
            r = ganz ? (double)Math.round(r) : Skalar.runder(r, Geopro.stellen);
        } else {
            r = Geopro.gerade[Gerade.nummer].radius;
        }
        return r;
    }

    @Override
    double neuerKugelradius(boolean ganz, int i, double X, double Y) {
        this.aktuell();
        double r = 0.0;
        Vektor3D p = Geopro.punkt[i].tripel;
        Vektor3D q = new Vektor3D(((double)X0 - X) / faktor, p.y, ((double)Y0 - Y) / faktor);
        r = Vektor3D.norm(Vektor3D.weg(p, q));
        r = ganz ? (double)Math.round(r) : Skalar.runder(r, Geopro.stellen);
        return r;
    }
}

