/*
 * Decompiled with CFR 0.152.
 */
class Vektor3D {
    double x;
    double y;
    double z;

    Vektor3D(Vektor3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    Vektor3D(double xx, double yy, double zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    Vektor3D(double aa) {
        this.x = aa;
        this.y = aa;
        this.z = aa;
    }

    Vektor3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    static Vektor3D kurz(Vektor3D v) {
        Vektor3D u = v;
        if (Skalar.ganz(u.x) && Skalar.ganz(u.y) && Skalar.ganz(u.z)) {
            Long ux = Skalar.Runde(u.x);
            Long uy = Skalar.Runde(u.y);
            Long uz = Skalar.Runde(u.z);
            Long g = Skalar.ggt3(ux, uy, uz);
            u.x = ux / g;
            u.y = uy / g;
            u.z = uz / g;
            return u;
        }
        return Vektor3D.eins(v);
    }

    static Vektor3D und(Vektor3D u, Vektor3D v) {
        return new Vektor3D(u.x + v.x, u.y + v.y, u.z + v.z);
    }

    static Vektor3D weg(Vektor3D u, Vektor3D v) {
        return new Vektor3D(u.x - v.x, u.y - v.y, u.z - v.z);
    }

    static Vektor3D mal(double t, Vektor3D v) {
        return new Vektor3D(t * v.x, t * v.y, t * v.z);
    }

    static Vektor3D mitte(Vektor3D u, Vektor3D v) {
        return Vektor3D.mal(0.5, new Vektor3D(u.x + v.x, u.y + v.y, u.z + v.z));
    }

    static Vektor3D schwer(Vektor3D u, Vektor3D v, Vektor3D w) {
        return Vektor3D.dur(new Vektor3D(u.x + v.x + w.x, u.y + v.y + w.y, u.z + v.z + w.z), 3.0);
    }

    static Vektor3D dur(Vektor3D v, double t) {
        return new Vektor3D(v.x / t, v.y / t, v.z / t);
    }

    static double skap(Vektor3D u, Vektor3D v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    static double norm(Vektor3D v) {
        return Math.sqrt(Vektor3D.skap(v, v));
    }

    static double wink(Vektor3D u, Vektor3D v) {
        return Math.acos(Vektor3D.skap(u, v) / (Vektor3D.norm(u) * Vektor3D.norm(v)));
    }

    static double wink(Vektor3D p, Vektor3D s, Vektor3D q) {
        Vektor3D u = Vektor3D.weg(p, s);
        Vektor3D v = Vektor3D.weg(q, s);
        if (Skalar.klein(Vektor3D.norm(u)) || Skalar.klein(Vektor3D.norm(v))) {
            return 0.0;
        }
        return Math.acos(Vektor3D.skap(u, v) / (Vektor3D.norm(u) * Vektor3D.norm(v)));
    }

    static double quot(Vektor3D p, Vektor3D s, Vektor3D q) {
        Vektor3D u = Vektor3D.weg(p, s);
        Vektor3D v = Vektor3D.weg(q, s);
        if (Skalar.klein(Vektor3D.norm(u)) || Skalar.klein(Vektor3D.norm(v))) {
            return 1.0;
        }
        return Vektor3D.norm(u) / Vektor3D.norm(v);
    }

    static double dist(Vektor3D a, Vektor3D b) {
        Vektor3D v = Vektor3D.weg(a, b);
        return Vektor3D.norm(v);
    }

    static boolean nullv(Vektor3D v) {
        return Skalar.klein(Vektor3D.norm(v));
    }

    static boolean ungleich(Vektor3D u, Vektor3D v) {
        return !Vektor3D.nullv(Vektor3D.weg(u, v));
    }

    static Vektor3D eins(Vektor3D v) {
        if (Vektor3D.nullv(v)) {
            return new Vektor3D(0.0, 0.0, 0.0);
        }
        return Vektor3D.dur(v, Vektor3D.norm(v));
    }

    static Vektor3D zehn(Vektor3D v) {
        return Vektor3D.mal(10.0, Vektor3D.dur(v, Vektor3D.norm(v)));
    }

    static Vektor3D vekp(Vektor3D u, Vektor3D v) {
        return new Vektor3D(u.y * v.z - u.z * v.y, u.z * v.x - u.x * v.z, u.x * v.y - u.y * v.x);
    }

    static boolean kollinear(Vektor3D u, Vektor3D v) {
        return Vektor3D.nullv(Vektor3D.vekp(u, v));
    }

    static boolean orthogonal(Vektor3D u, Vektor3D v) {
        return Skalar.klein(Vektor3D.skap(u, v));
    }

    static double spat(Vektor3D u, Vektor3D v, Vektor3D w) {
        return Vektor3D.skap(Vektor3D.vekp(u, v), w);
    }

    static Vektor3D drehpunkt(Vektor3D m, Vektor3D p, double w) {
        double sW = Math.sin(Math.PI / 180 * w);
        double cW = Math.cos(Math.PI / 180 * w);
        Vektor3D u = Vektor3D.weg(p, m);
        Vektor3D v = new Vektor3D();
        v.x = cW * u.x - sW * u.y;
        v.y = sW * u.x + cW * u.y;
        Vektor3D q = Vektor3D.und(m, v);
        return q;
    }

    static Vektor3D rytz(Vektor2D M, Vektor2D P, Vektor2D Q) {
        Vektor2D V = Vektor2D.weg(Q, M);
        Vektor2D U = new Vektor2D(-V.y, V.x);
        Vektor2D QQ = Vektor2D.und(M, U);
        Vektor2D Z = Vektor2D.mitte(QQ, P);
        double r = Vektor2D.norm(Vektor2D.weg(Z, M));
        Vektor2D W = Vektor2D.mal(r, Vektor2D.eins(Vektor2D.weg(P, Z)));
        Vektor2D AA = Vektor2D.und(Z, W);
        Vektor2D BB = Vektor2D.und(Z, Vektor2D.mal(-1.0, W));
        double a = Vektor2D.norm(Vektor2D.weg(P, BB));
        double b = Vektor2D.norm(Vektor2D.weg(P, AA));
        Vektor2D A = Vektor2D.und(M, Vektor2D.mal(-a, Vektor2D.eins(Vektor2D.weg(AA, M))));
        double w = Skalar.atan(A.y - M.y, A.x - M.x);
        return new Vektor3D(a, b, w);
    }
}

